/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2HuffmanDecoder;
import io.helidon.http.http2.Http2LoggingFrameListener;
import io.helidon.http.http2.Http2Priority;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2Stream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.http2.Http2ClientConnection;
import io.helidon.webclient.http2.LockingStreamIdSequence;
import io.helidon.webclient.http2.StreamBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class Http2ClientStream
implements Http2Stream,
ReleasableResource {
    private static final System.Logger LOGGER = System.getLogger(Http2ClientStream.class.getName());
    private static final Set<Http2StreamState> NON_CANCELABLE = Set.of(Http2StreamState.CLOSED, Http2StreamState.IDLE);
    private final Http2ClientConnection connection;
    private final Http2Settings serverSettings;
    private final SocketContext ctx;
    private final Duration timeout;
    private final LockingStreamIdSequence streamIdSeq;
    private final Http2FrameListener sendListener = new Http2LoggingFrameListener("cl-send");
    private final Http2FrameListener recvListener = new Http2LoggingFrameListener("cl-recv");
    private final Http2Settings settings = Http2Settings.create();
    private final List<Http2FrameData> continuationData = new ArrayList<Http2FrameData>();
    private Http2StreamState state = Http2StreamState.IDLE;
    private Http2Headers currentHeaders;
    private volatile StreamFlowControl flowControl;
    private boolean hasEntity;
    private int streamId;
    private StreamBuffer buffer;

    Http2ClientStream(Http2ClientConnection connection, Http2Settings serverSettings, SocketContext ctx, Duration timeout, LockingStreamIdSequence streamIdSeq) {
        this.connection = connection;
        this.serverSettings = serverSettings;
        this.ctx = ctx;
        this.timeout = timeout;
        this.streamIdSeq = streamIdSeq;
    }

    public int streamId() {
        return this.streamId;
    }

    public Http2StreamState streamState() {
        return this.state;
    }

    public void headers(Http2Headers headers, boolean endOfStream) {
        this.currentHeaders = headers;
        this.hasEntity = !endOfStream;
    }

    public void rstStream(Http2RstStream rstStream) {
        if (this.state == Http2StreamState.IDLE) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received RST_STREAM for stream " + this.streamId + " in IDLE state");
        }
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.RST_STREAM, (boolean)false, (boolean)false, (boolean)false);
        throw new RuntimeException("Reset of " + this.streamId + " stream received!");
    }

    public void windowUpdate(Http2WindowUpdate windowUpdate) {
        Http2RstStream frame;
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.WINDOW_UPDATE, (boolean)false, (boolean)false, (boolean)false);
        int increment = windowUpdate.windowSizeIncrement();
        if (increment == 0) {
            frame = new Http2RstStream(Http2ErrorCode.PROTOCOL);
            this.connection.writer().write(frame.toFrameData(this.serverSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        if (this.flowControl.outbound().incrementStreamWindowSize(increment) > Integer.MAX_VALUE) {
            frame = new Http2RstStream(Http2ErrorCode.FLOW_CONTROL);
            this.connection.writer().write(frame.toFrameData(this.serverSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        this.flowControl().outbound().incrementStreamWindowSize(increment);
    }

    public void data(Http2FrameHeader header, BufferData data) {
        this.flowControl.inbound().incrementWindowSize(header.length());
    }

    public void priority(Http2Priority http2Priority) {
    }

    public StreamFlowControl flowControl() {
        return this.flowControl;
    }

    public void closeResource() {
        this.close();
    }

    boolean hasEntity() {
        return this.hasEntity;
    }

    void cancel() {
        if (NON_CANCELABLE.contains(this.state)) {
            return;
        }
        Http2RstStream rstStream = new Http2RstStream(Http2ErrorCode.CANCEL);
        Http2FrameData frameData = rstStream.toFrameData(this.settings, this.streamId, Http2Flag.NoFlags.create());
        this.sendListener.frameHeader(this.ctx, this.streamId, frameData.header());
        this.sendListener.frame(this.ctx, this.streamId, rstStream);
        try {
            this.write(frameData, false);
        }
        catch (UncheckedIOException e) {
            this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "Exception during stream cancel", (Throwable)e, new Object[0]);
        }
    }

    void close() {
        this.connection.removeStream(this.streamId);
    }

    void push(Http2FrameData frameData) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "%d: received frame of type %s, pushing to buffer", new Object[]{this.streamId, frameData.header().type()});
        }
        this.buffer.push(frameData);
    }

    BufferData read(int i) {
        return this.read();
    }

    BufferData read() {
        while (this.state == Http2StreamState.HALF_CLOSED_LOCAL) {
            Http2FrameData frameData = this.readOne();
            if (frameData == null) continue;
            return frameData.data();
        }
        return BufferData.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Http2Headers http2Headers, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.HEADERS, (boolean)true, (boolean)endOfStream, (boolean)true);
        Http2Flag.HeaderFlags flags = endOfStream ? Http2Flag.HeaderFlags.create((int)5) : Http2Flag.HeaderFlags.create((int)4);
        try {
            this.streamId = this.streamIdSeq.lockAndNext();
            this.connection.updateLastStreamId(this.streamId);
            this.buffer = new StreamBuffer(this.streamId, this.timeout);
            this.flowControl = this.connection.flowControl().createStreamFlowControl(this.streamId, 65535, 16384);
            this.connection.addStream(this.streamId, this);
            this.sendListener.headers(this.ctx, this.streamId, http2Headers);
            this.connection.writer().writeHeaders(http2Headers, this.streamId, flags, this.flowControl.outbound());
        }
        finally {
            this.streamIdSeq.unlock();
        }
    }

    void writeData(BufferData entityBytes, boolean endOfStream) {
        Http2FrameHeader frameHeader = Http2FrameHeader.create((int)entityBytes.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)(endOfStream ? 1 : 0)), (int)this.streamId);
        Http2FrameData frameData = new Http2FrameData(frameHeader, entityBytes);
        this.splitAndWrite(frameData);
    }

    Http2Headers readHeaders() {
        while (this.currentHeaders == null) {
            Http2FrameData frameData = this.readOne();
            if (frameData == null) continue;
            throw new IllegalStateException("Unexpected frame type " + String.valueOf(frameData.header()) + ", HEADERS are expected.");
        }
        return this.currentHeaders;
    }

    ClientOutputStream outputStream() {
        return new ClientOutputStream();
    }

    private Http2FrameData readOne() {
        Http2FrameData frameData = this.buffer.poll();
        if (frameData != null) {
            this.recvListener.frameHeader(this.ctx, this.streamId, frameData.header());
            this.recvListener.frame(this.ctx, this.streamId, frameData.data());
            int flags = frameData.header().flags();
            boolean endOfStream = (flags & 1) == 1;
            boolean endOfHeaders = (flags & 4) == 4;
            this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)frameData.header().type(), (boolean)false, (boolean)endOfStream, (boolean)endOfHeaders);
            switch (frameData.header().type()) {
                case DATA: {
                    this.data(frameData.header(), frameData.data());
                    return frameData;
                }
                case HEADERS: 
                case CONTINUATION: {
                    this.continuationData.add(frameData);
                    if (!endOfHeaders) break;
                    Http2HuffmanDecoder requestHuffman = Http2HuffmanDecoder.create();
                    Http2Headers http2Headers = Http2Headers.create((Http2Stream)this, (Http2Headers.DynamicTable)this.connection.getInboundDynamicTable(), (Http2HuffmanDecoder)requestHuffman, (Http2FrameData[])this.continuationData.toArray(new Http2FrameData[0]));
                    this.recvListener.headers(this.ctx, this.streamId, http2Headers);
                    this.headers(http2Headers, endOfStream);
                    break;
                }
                default: {
                    LOGGER.log(System.Logger.Level.DEBUG, "Dropping frame " + String.valueOf(frameData.header()) + " expected header or data.");
                }
            }
        }
        return null;
    }

    private void splitAndWrite(Http2FrameData frameData) {
        Http2FrameData[] frames;
        int maxFrameSize = ((Long)this.serverSettings.value(Http2Setting.MAX_FRAME_SIZE)).intValue();
        for (Http2FrameData frame : frames = frameData.split(maxFrameSize)) {
            this.write(frame, ((Http2Flag.DataFlags)frame.header().flags(Http2FrameTypes.DATA)).endOfStream());
        }
    }

    private void write(Http2FrameData frameData, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)frameData.header().type(), (boolean)true, (boolean)endOfStream, (boolean)false);
        this.connection.writer().writeData(frameData, this.flowControl().outbound());
    }

    class ClientOutputStream
    extends OutputStream {
        private volatile boolean isClosed;

        ClientOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(0, 1, (byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(off, len, b);
        }

        @Override
        public void close() throws IOException {
            Http2ClientStream.this.writeData(BufferData.empty(), true);
            this.isClosed = true;
            super.close();
        }

        public boolean closed() {
            return this.isClosed;
        }

        private void write(int off, int len, byte ... bytes) {
            Http2ClientStream.this.writeData(BufferData.create((byte[])bytes, (int)off, (int)len), false);
        }
    }
}

