/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.webclient.grpc.GrpcClientImpl;
import io.helidon.webclient.grpc.GrpcClientMethodDescriptor;
import io.helidon.webclient.grpc.GrpcServiceClient;
import io.helidon.webclient.grpc.GrpcServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

class GrpcServiceClientImpl
implements GrpcServiceClient {
    private final GrpcServiceDescriptor serviceDescriptor;
    private final Channel serviceChannel;
    private final GrpcClientImpl grpcClient;
    private final Map<String, Channel> methodCache = new ConcurrentHashMap<String, Channel>();

    GrpcServiceClientImpl(GrpcServiceDescriptor descriptor, GrpcClientImpl grpcClient) {
        this.serviceDescriptor = descriptor;
        this.grpcClient = grpcClient;
        if (descriptor.interceptors().isEmpty()) {
            this.serviceChannel = grpcClient.channel();
        } else {
            WeightedBag interceptors = WeightedBag.create();
            for (ClientInterceptor interceptor : descriptor.interceptors()) {
                interceptors.add((Object)interceptor);
            }
            SequencedCollection orderedInterceptors = interceptors.stream().toList().reversed();
            this.serviceChannel = ClientInterceptors.intercept((Channel)grpcClient.channel(), (List)orderedInterceptors);
        }
    }

    @Override
    public String serviceName() {
        return this.serviceDescriptor.serviceName();
    }

    @Override
    public <ReqT, ResT> ResT unary(String methodName, ReqT request) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.UNARY);
        return (ResT)ClientCalls.blockingUnaryCall(call, request);
    }

    @Override
    public <ReqT, ResT> void unary(String methodName, ReqT request, StreamObserver<ResT> response) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.UNARY);
        ClientCalls.asyncUnaryCall(call, request, response);
    }

    @Override
    public <ReqT, ResT> Iterator<ResT> serverStream(String methodName, ReqT request) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.SERVER_STREAMING);
        return ClientCalls.blockingServerStreamingCall(call, request);
    }

    @Override
    public <ReqT, ResT> void serverStream(String methodName, ReqT request, StreamObserver<ResT> response) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.SERVER_STREAMING);
        ClientCalls.asyncServerStreamingCall(call, request, response);
    }

    @Override
    public <ReqT, ResT> ResT clientStream(String methodName, Iterator<ReqT> request) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.CLIENT_STREAMING);
        final CompletableFuture future = new CompletableFuture();
        StreamObserver observer = ClientCalls.asyncClientStreamingCall(call, (StreamObserver)new StreamObserver<ResT>(this){
            private ResT value;

            public void onNext(ResT value) {
                this.value = value;
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
                future.complete(this.value);
            }
        });
        while (request.hasNext()) {
            observer.onNext(request.next());
        }
        observer.onCompleted();
        try {
            return (ResT)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ReqT, ResT> StreamObserver<ReqT> clientStream(String methodName, StreamObserver<ResT> response) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.CLIENT_STREAMING);
        return ClientCalls.asyncClientStreamingCall(call, response);
    }

    @Override
    public <ReqT, ResT> Iterator<ResT> bidi(String methodName, Iterator<ReqT> request) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.BIDI_STREAMING);
        final CompletableFuture future = new CompletableFuture();
        StreamObserver observer = ClientCalls.asyncBidiStreamingCall(call, (StreamObserver)new StreamObserver<ResT>(this){
            private final List<ResT> values = new ArrayList();

            public void onNext(ResT value) {
                this.values.add(value);
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
                future.complete(this.values.iterator());
            }
        });
        while (request.hasNext()) {
            observer.onNext(request.next());
        }
        observer.onCompleted();
        try {
            return (Iterator)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ReqT, ResT> StreamObserver<ReqT> bidi(String methodName, StreamObserver<ResT> response) {
        ClientCall<ReqT, ResT> call = this.ensureMethod(methodName, MethodDescriptor.MethodType.BIDI_STREAMING);
        return ClientCalls.asyncBidiStreamingCall(call, response);
    }

    private <ReqT, ResT> ClientCall<ReqT, ResT> ensureMethod(String methodName, MethodDescriptor.MethodType methodType) {
        GrpcClientMethodDescriptor methodDescriptor = this.serviceDescriptor.method(methodName);
        if (!methodDescriptor.type().equals((Object)methodType)) {
            throw new IllegalArgumentException("Method " + methodName + " is of type " + String.valueOf(methodDescriptor.type()) + ", yet " + String.valueOf(methodType) + " was requested.");
        }
        if (methodDescriptor.interceptors().isEmpty()) {
            return this.serviceChannel.newCall(methodDescriptor.descriptor(), CallOptions.DEFAULT);
        }
        Channel methodChannel = this.methodCache.computeIfAbsent(methodName, k -> {
            WeightedBag interceptors = WeightedBag.create();
            for (ClientInterceptor interceptor : this.serviceDescriptor.interceptors()) {
                interceptors.add((Object)interceptor);
            }
            interceptors.merge(methodDescriptor.interceptors());
            SequencedCollection orderedInterceptors = interceptors.stream().toList().reversed();
            return ClientInterceptors.intercept((Channel)this.grpcClient.channel(), (List)orderedInterceptors);
        });
        return methodChannel.newCall(methodDescriptor.descriptor(), CallOptions.DEFAULT);
    }
}

