/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.webclient.grpc.GrpcClientProtocolConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.grpc.GrpcClientProtocolConfigBlueprint")
public interface GrpcClientProtocolConfig
extends GrpcClientProtocolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcClientProtocolConfig instance) {
        return (Builder)GrpcClientProtocolConfig.builder().from(instance);
    }

    public static GrpcClientProtocolConfig create(Config config) {
        return ((Builder)GrpcClientProtocolConfig.builder().config(config)).buildPrototype();
    }

    public static GrpcClientProtocolConfig create() {
        return GrpcClientProtocolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcClientProtocolConfig>
    implements io.helidon.common.Builder<Builder, GrpcClientProtocolConfig> {
        private Builder() {
        }

        public GrpcClientProtocolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcClientProtocolConfigImpl(this);
        }

        public GrpcClientProtocolConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcClientProtocolConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean abortPollTimeExpired = false;
        private Config config;
        private Duration heartbeatPeriod = Duration.parse("PT0S");
        private Duration pollWaitTime = Duration.parse("PT10S");
        private int initBufferSize = 2048;
        private String name = "grpc";

        protected BuilderBase() {
        }

        public BUILDER from(GrpcClientProtocolConfig prototype) {
            this.name(prototype.name());
            this.pollWaitTime(prototype.pollWaitTime());
            this.abortPollTimeExpired(prototype.abortPollTimeExpired());
            this.heartbeatPeriod(prototype.heartbeatPeriod());
            this.initBufferSize(prototype.initBufferSize());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            this.pollWaitTime(builder.pollWaitTime());
            this.abortPollTimeExpired(builder.abortPollTimeExpired());
            this.heartbeatPeriod(builder.heartbeatPeriod());
            this.initBufferSize(builder.initBufferSize());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("poll-wait-time").as(Duration.class).ifPresent(this::pollWaitTime);
            config.get("abort-poll-time-expired").as(Boolean.class).ifPresent(this::abortPollTimeExpired);
            config.get("heartbeat-period").as(Duration.class).ifPresent(this::heartbeatPeriod);
            config.get("init-buffer-size").as(Integer.class).ifPresent(this::initBufferSize);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pollWaitTime(Duration pollWaitTime) {
            Objects.requireNonNull(pollWaitTime);
            this.pollWaitTime = pollWaitTime;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER abortPollTimeExpired(boolean abortPollTimeExpired) {
            this.abortPollTimeExpired = abortPollTimeExpired;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER heartbeatPeriod(Duration heartbeatPeriod) {
            Objects.requireNonNull(heartbeatPeriod);
            this.heartbeatPeriod = heartbeatPeriod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initBufferSize(int initBufferSize) {
            this.initBufferSize = initBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public Duration pollWaitTime() {
            return this.pollWaitTime;
        }

        public boolean abortPollTimeExpired() {
            return this.abortPollTimeExpired;
        }

        public Duration heartbeatPeriod() {
            return this.heartbeatPeriod;
        }

        public int initBufferSize() {
            return this.initBufferSize;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcClientProtocolConfigBuilder{name=" + this.name + ",pollWaitTime=" + String.valueOf(this.pollWaitTime) + ",abortPollTimeExpired=" + this.abortPollTimeExpired + ",heartbeatPeriod=" + String.valueOf(this.heartbeatPeriod) + ",initBufferSize=" + this.initBufferSize + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class GrpcClientProtocolConfigImpl
        implements GrpcClientProtocolConfig {
            private final boolean abortPollTimeExpired;
            private final Duration heartbeatPeriod;
            private final Duration pollWaitTime;
            private final int initBufferSize;
            private final String name;

            protected GrpcClientProtocolConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.pollWaitTime = builder.pollWaitTime();
                this.abortPollTimeExpired = builder.abortPollTimeExpired();
                this.heartbeatPeriod = builder.heartbeatPeriod();
                this.initBufferSize = builder.initBufferSize();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Duration pollWaitTime() {
                return this.pollWaitTime;
            }

            @Override
            public boolean abortPollTimeExpired() {
                return this.abortPollTimeExpired;
            }

            @Override
            public Duration heartbeatPeriod() {
                return this.heartbeatPeriod;
            }

            @Override
            public int initBufferSize() {
                return this.initBufferSize;
            }

            public String toString() {
                return "GrpcClientProtocolConfig{name=" + this.name + ",pollWaitTime=" + String.valueOf(this.pollWaitTime) + ",abortPollTimeExpired=" + this.abortPollTimeExpired + ",heartbeatPeriod=" + String.valueOf(this.heartbeatPeriod) + ",initBufferSize=" + this.initBufferSize + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcClientProtocolConfig)) {
                    return false;
                }
                GrpcClientProtocolConfig other = (GrpcClientProtocolConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.pollWaitTime, other.pollWaitTime()) && this.abortPollTimeExpired == other.abortPollTimeExpired() && Objects.equals(this.heartbeatPeriod, other.heartbeatPeriod()) && this.initBufferSize == other.initBufferSize();
            }

            public int hashCode() {
                return Objects.hash(this.name, this.pollWaitTime, this.abortPollTimeExpired, this.heartbeatPeriod, this.initBufferSize);
            }
        }
    }
}

