/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.Status;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponseBlueprint;
import io.helidon.webclient.api.WebClientServiceResponseDecorator;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.api.WebClientServiceResponseBlueprint")
public interface WebClientServiceResponse
extends WebClientServiceResponseBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebClientServiceResponse instance) {
        return (Builder)WebClientServiceResponse.builder().from(instance);
    }

    public static WebClientServiceResponse create() {
        return WebClientServiceResponse.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WebClientServiceResponse>
    implements io.helidon.common.Builder<Builder, WebClientServiceResponse> {
        private Builder() {
        }

        public WebClientServiceResponse buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WebClientServiceResponseImpl(this);
        }

        public WebClientServiceResponse build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientServiceResponse>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private ClientResponseHeaders headers;
        private CompletableFuture<WebClientServiceResponse> whenComplete;
        private CompletableFuture<ClientResponseTrailers> trailers;
        private InputStream inputStream;
        private ReleasableResource connection;
        private Status status;
        private WebClientServiceRequest serviceRequest;

        protected BuilderBase() {
        }

        public BUILDER from(WebClientServiceResponse prototype) {
            this.headers(prototype.headers());
            this.trailers(prototype.trailers());
            this.status(prototype.status());
            this.inputStream(prototype.inputStream());
            this.connection(prototype.connection());
            this.whenComplete(prototype.whenComplete());
            this.serviceRequest(prototype.serviceRequest());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.headers().ifPresent(this::headers);
            builder.trailers().ifPresent(this::trailers);
            builder.status().ifPresent(this::status);
            builder.inputStream().ifPresent(this::inputStream);
            builder.connection().ifPresent(this::connection);
            builder.whenComplete().ifPresent(this::whenComplete);
            builder.serviceRequest().ifPresent(this::serviceRequest);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER headers(ClientResponseHeaders headers) {
            Objects.requireNonNull(headers);
            this.headers = headers;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trailers(CompletableFuture<ClientResponseTrailers> trailers) {
            Objects.requireNonNull(trailers);
            this.trailers = trailers;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER status(Status status) {
            Objects.requireNonNull(status);
            this.status = status;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInputStream() {
            this.inputStream = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inputStream(InputStream inputStream) {
            Objects.requireNonNull(inputStream);
            this.inputStream = inputStream;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connection(ReleasableResource connection) {
            Objects.requireNonNull(connection);
            this.connection = connection;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER whenComplete(CompletableFuture<WebClientServiceResponse> whenComplete) {
            Objects.requireNonNull(whenComplete);
            this.whenComplete = whenComplete;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceRequest(WebClientServiceRequest serviceRequest) {
            Objects.requireNonNull(serviceRequest);
            this.serviceRequest = serviceRequest;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ClientResponseHeaders> headers() {
            return Optional.ofNullable(this.headers);
        }

        public Optional<CompletableFuture<ClientResponseTrailers>> trailers() {
            return Optional.ofNullable(this.trailers);
        }

        public Optional<Status> status() {
            return Optional.ofNullable(this.status);
        }

        public Optional<InputStream> inputStream() {
            return Optional.ofNullable(this.inputStream);
        }

        public Optional<ReleasableResource> connection() {
            return Optional.ofNullable(this.connection);
        }

        public Optional<CompletableFuture<WebClientServiceResponse>> whenComplete() {
            return Optional.ofNullable(this.whenComplete);
        }

        public Optional<WebClientServiceRequest> serviceRequest() {
            return Optional.ofNullable(this.serviceRequest);
        }

        public String toString() {
            return "WebClientServiceResponseBuilder{headers=" + String.valueOf(this.headers) + ",trailers=" + String.valueOf(this.trailers) + ",status=" + String.valueOf(this.status) + ",inputStream=" + String.valueOf(this.inputStream) + ",connection=" + String.valueOf(this.connection) + ",whenComplete=" + String.valueOf(this.whenComplete) + ",serviceRequest=" + String.valueOf(this.serviceRequest) + "}";
        }

        protected void preBuildPrototype() {
            new WebClientServiceResponseDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.headers == null) {
                collector.fatal(this.getClass(), "Property \"headers\" must not be null, but not set");
            }
            if (this.trailers == null) {
                collector.fatal(this.getClass(), "Property \"trailers\" must not be null, but not set");
            }
            if (this.status == null) {
                collector.fatal(this.getClass(), "Property \"status\" must not be null, but not set");
            }
            if (this.connection == null) {
                collector.fatal(this.getClass(), "Property \"connection\" must not be null, but not set");
            }
            if (this.whenComplete == null) {
                collector.fatal(this.getClass(), "Property \"whenComplete\" must not be null, but not set");
            }
            if (this.serviceRequest == null) {
                collector.fatal(this.getClass(), "Property \"serviceRequest\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER inputStream(Optional<? extends InputStream> inputStream) {
            Objects.requireNonNull(inputStream);
            this.inputStream = inputStream.map(InputStream.class::cast).orElse(this.inputStream);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class WebClientServiceResponseImpl
        implements WebClientServiceResponse {
            private final ClientResponseHeaders headers;
            private final CompletableFuture<WebClientServiceResponse> whenComplete;
            private final CompletableFuture<ClientResponseTrailers> trailers;
            private final Optional<InputStream> inputStream;
            private final ReleasableResource connection;
            private final Status status;
            private final WebClientServiceRequest serviceRequest;

            protected WebClientServiceResponseImpl(BuilderBase<?, ?> builder) {
                this.headers = builder.headers().get();
                this.trailers = builder.trailers().get();
                this.status = builder.status().get();
                this.inputStream = builder.inputStream();
                this.connection = builder.connection().get();
                this.whenComplete = builder.whenComplete().get();
                this.serviceRequest = builder.serviceRequest().get();
            }

            @Override
            public ClientResponseHeaders headers() {
                return this.headers;
            }

            @Override
            public CompletableFuture<ClientResponseTrailers> trailers() {
                return this.trailers;
            }

            @Override
            public Status status() {
                return this.status;
            }

            @Override
            public Optional<InputStream> inputStream() {
                return this.inputStream;
            }

            @Override
            public ReleasableResource connection() {
                return this.connection;
            }

            @Override
            public CompletableFuture<WebClientServiceResponse> whenComplete() {
                return this.whenComplete;
            }

            @Override
            public WebClientServiceRequest serviceRequest() {
                return this.serviceRequest;
            }

            public String toString() {
                return "WebClientServiceResponse{headers=" + String.valueOf(this.headers) + ",trailers=" + String.valueOf(this.trailers) + ",status=" + String.valueOf(this.status) + ",inputStream=" + String.valueOf(this.inputStream) + ",connection=" + String.valueOf(this.connection) + ",whenComplete=" + String.valueOf(this.whenComplete) + ",serviceRequest=" + String.valueOf(this.serviceRequest) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientServiceResponse)) {
                    return false;
                }
                WebClientServiceResponse other = (WebClientServiceResponse)o;
                return Objects.equals(this.headers, other.headers()) && Objects.equals(this.trailers, other.trailers()) && Objects.equals(this.status, other.status()) && Objects.equals(this.inputStream, other.inputStream()) && Objects.equals(this.connection, other.connection()) && Objects.equals(this.whenComplete, other.whenComplete()) && Objects.equals(this.serviceRequest, other.serviceRequest());
            }

            public int hashCode() {
                return Objects.hash(this.headers, this.trailers, this.status, this.inputStream, this.connection, this.whenComplete, this.serviceRequest);
            }
        }
    }
}

