/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Headers;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.http.media.ReadableEntityBase;
import java.util.function.Function;

public final class ClientResponseEntity
extends ReadableEntityBase
implements ReadableEntity {
    private final ClientRequestHeaders requestHeaders;
    private final ClientResponseHeaders responseHeaders;
    private final MediaContext mediaContext;

    private ClientResponseEntity(Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders, MediaContext mediaContext) {
        super(readEntityFunction, entityProcessedRunnable);
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.mediaContext = mediaContext;
    }

    public static ClientResponseEntity create(Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders, MediaContext mediaContext) {
        return new ClientResponseEntity(readEntityFunction, entityProcessedRunnable, requestHeaders, responseHeaders, mediaContext);
    }

    public ReadableEntity copy(Runnable entityProcessedRunnable) {
        return new ClientResponseEntity(this.readEntityFunction(), () -> {
            entityProcessedRunnable.run();
            this.entityProcessedRunnable().run();
        }, this.requestHeaders, this.responseHeaders, this.mediaContext);
    }

    protected <T> T entityAs(GenericType<T> type) {
        return (T)this.mediaContext.reader(type, (Headers)this.requestHeaders, (Headers)this.responseHeaders).read(type, this.inputStream(), (Headers)this.requestHeaders, (Headers)this.responseHeaders);
    }
}

