/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.api.WebClientCookieManagerConfigBlueprint;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webclient.api.WebClientCookieManagerConfigBlueprint")
public interface WebClientCookieManagerConfig
extends WebClientCookieManagerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebClientCookieManagerConfig instance) {
        return (Builder)WebClientCookieManagerConfig.builder().from(instance);
    }

    public static WebClientCookieManagerConfig create(Config config) {
        return ((Builder)WebClientCookieManagerConfig.builder().config(config)).buildPrototype();
    }

    public static WebClientCookieManagerConfig create() {
        return WebClientCookieManagerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WebClientCookieManagerConfig>
    implements io.helidon.common.Builder<Builder, WebClientCookieManager> {
        private Builder() {
        }

        public WebClientCookieManagerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WebClientCookieManagerConfigImpl(this);
        }

        public WebClientCookieManager build() {
            return WebClientCookieManager.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientCookieManagerConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, String> defaultCookies = new LinkedHashMap<String, String>();
        private boolean automaticStoreEnabled = false;
        private Config config;
        private CookiePolicy cookiePolicy = CookiePolicy.ACCEPT_ORIGINAL_SERVER;
        private CookieStore cookieStore;

        protected BuilderBase() {
        }

        public BUILDER from(WebClientCookieManagerConfig prototype) {
            this.automaticStoreEnabled(prototype.automaticStoreEnabled());
            this.cookiePolicy(prototype.cookiePolicy());
            this.addDefaultCookies(prototype.defaultCookies());
            this.cookieStore(prototype.cookieStore());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.automaticStoreEnabled(builder.automaticStoreEnabled());
            this.cookiePolicy(builder.cookiePolicy());
            this.addDefaultCookies(builder.defaultCookies());
            builder.cookieStore().ifPresent(this::cookieStore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("automatic-store-enabled").as(Boolean.class).ifPresent(this::automaticStoreEnabled);
            config.get("cookie-policy").as(CookiePolicy.class).ifPresent(this::cookiePolicy);
            config.get("default-cookies").detach().asMap().ifPresent(this::defaultCookies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER automaticStoreEnabled(boolean automaticStoreEnabled) {
            this.automaticStoreEnabled = automaticStoreEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cookiePolicy(CookiePolicy cookiePolicy) {
            Objects.requireNonNull(cookiePolicy);
            this.cookiePolicy = cookiePolicy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultCookies(Map<? extends String, ? extends String> defaultCookies) {
            Objects.requireNonNull(defaultCookies);
            this.defaultCookies.clear();
            this.defaultCookies.putAll(defaultCookies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDefaultCookies(Map<? extends String, ? extends String> defaultCookies) {
            Objects.requireNonNull(defaultCookies);
            this.defaultCookies.putAll(defaultCookies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putDefaultCookie(String key, String defaultCookie) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(defaultCookie);
            this.defaultCookies.put(key, defaultCookie);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCookieStore() {
            this.cookieStore = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cookieStore(CookieStore cookieStore) {
            Objects.requireNonNull(cookieStore);
            this.cookieStore = cookieStore;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean automaticStoreEnabled() {
            return this.automaticStoreEnabled;
        }

        public CookiePolicy cookiePolicy() {
            return this.cookiePolicy;
        }

        public Map<String, String> defaultCookies() {
            return this.defaultCookies;
        }

        public Optional<CookieStore> cookieStore() {
            return Optional.ofNullable(this.cookieStore);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "WebClientCookieManagerConfigBuilder{automaticStoreEnabled=" + this.automaticStoreEnabled + ",cookiePolicy=" + String.valueOf(this.cookiePolicy) + ",defaultCookies=" + String.valueOf(this.defaultCookies) + ",cookieStore=" + String.valueOf(this.cookieStore) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER cookieStore(Optional<? extends CookieStore> cookieStore) {
            Objects.requireNonNull(cookieStore);
            this.cookieStore = cookieStore.map(CookieStore.class::cast).orElse(this.cookieStore);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class WebClientCookieManagerConfigImpl
        implements WebClientCookieManagerConfig,
        Supplier<WebClientCookieManager> {
            private final boolean automaticStoreEnabled;
            private final CookiePolicy cookiePolicy;
            private final Map<String, String> defaultCookies;
            private final Optional<CookieStore> cookieStore;

            protected WebClientCookieManagerConfigImpl(BuilderBase<?, ?> builder) {
                this.automaticStoreEnabled = builder.automaticStoreEnabled();
                this.cookiePolicy = builder.cookiePolicy();
                this.defaultCookies = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.defaultCookies()));
                this.cookieStore = builder.cookieStore();
            }

            public WebClientCookieManager build() {
                return WebClientCookieManager.create(this);
            }

            @Override
            public WebClientCookieManager get() {
                return this.build();
            }

            @Override
            public boolean automaticStoreEnabled() {
                return this.automaticStoreEnabled;
            }

            @Override
            public CookiePolicy cookiePolicy() {
                return this.cookiePolicy;
            }

            @Override
            public Map<String, String> defaultCookies() {
                return this.defaultCookies;
            }

            @Override
            public Optional<CookieStore> cookieStore() {
                return this.cookieStore;
            }

            public String toString() {
                return "WebClientCookieManagerConfig{automaticStoreEnabled=" + this.automaticStoreEnabled + ",cookiePolicy=" + String.valueOf(this.cookiePolicy) + ",defaultCookies=" + String.valueOf(this.defaultCookies) + ",cookieStore=" + String.valueOf(this.cookieStore) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientCookieManagerConfig)) {
                    return false;
                }
                WebClientCookieManagerConfig other = (WebClientCookieManagerConfig)o;
                return this.automaticStoreEnabled == other.automaticStoreEnabled() && Objects.equals(this.cookiePolicy, other.cookiePolicy()) && Objects.equals(this.defaultCookies, other.defaultCookies()) && Objects.equals(this.cookieStore, other.cookieStore());
            }

            public int hashCode() {
                return Objects.hash(this.automaticStoreEnabled, this.cookiePolicy, this.defaultCookies, this.cookieStore);
            }
        }
    }
}

