/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.config.Config;
import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.LruCacheConfig;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Proxy {
    private static final System.Logger LOGGER = System.getLogger(Proxy.class.getName());
    private static final Tls NO_TLS = ((TlsConfig.Builder)Tls.builder().enabled(false)).build();
    private static final Header PROXY_CONNECTION = HeaderValues.create((String)"Proxy-Connection", (String)"keep-alive");
    private static final Proxy NO_PROXY = new Proxy(Proxy.builder().type(ProxyType.NONE));
    private static final Pattern PORT_PATTERN = Pattern.compile(".*:(\\d+)");
    private static final Pattern IP_V4 = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IP_V6_IDENTIFIER = Pattern.compile("^\\[(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}]$");
    private static final Pattern IP_V6_HEX_IDENTIFIER = Pattern.compile("^\\[((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)]$");
    private static final Pattern IP_V6_HOST = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IP_V6_HEX_HOST = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final LruCache<String, Boolean> IVP6_HOST_MATCH_RESULTS = ((LruCacheConfig.Builder)LruCache.builder().capacity(100)).build();
    private static final LruCache<String, Boolean> IVP6_IDENTIFIER_MATCH_RESULTS = ((LruCacheConfig.Builder)LruCache.builder().capacity(100)).build();
    private final ProxyType type;
    private final String host;
    private final int port;
    private final Function<InetSocketAddress, Boolean> noProxy;
    private final Optional<String> username;
    private final Optional<char[]> password;
    private final ProxySelector systemProxySelector;
    private final Optional<Header> proxyAuthHeader;

    private Proxy(Builder builder) {
        this.host = builder.host();
        this.type = this.host != null ? ProxyType.HTTP : builder.type();
        this.port = builder.port();
        this.username = builder.username();
        this.password = builder.password();
        if (this.type == ProxyType.SYSTEM) {
            this.noProxy = inetSocketAddress -> true;
            this.systemProxySelector = ProxySelector.getDefault();
        } else {
            this.noProxy = Proxy.prepareNoProxy(builder.noProxyHosts());
            this.systemProxySelector = null;
        }
        if (this.username.isPresent()) {
            char[] pass = this.password.orElse(new char[0]);
            String b64 = Base64.getEncoder().encodeToString((this.username.get() + ":" + new String(pass)).getBytes(StandardCharsets.UTF_8));
            this.proxyAuthHeader = Optional.of(HeaderValues.create((HeaderName)HeaderNames.PROXY_AUTHORIZATION, (String)("Basic " + b64)));
        } else {
            this.proxyAuthHeader = Optional.empty();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Proxy noProxy() {
        return NO_PROXY;
    }

    public static Proxy create(Config config) {
        return Proxy.builder().config(config).build();
    }

    public static Proxy create() {
        return Proxy.builder().type(ProxyType.SYSTEM).build();
    }

    static Function<InetSocketAddress, Boolean> prepareNoProxy(Set<String> noProxyHosts) {
        if (noProxyHosts.isEmpty()) {
            return address -> false;
        }
        boolean simple = true;
        for (String noProxyHost : noProxyHosts) {
            if (!noProxyHost.startsWith(".")) continue;
            simple = false;
            break;
        }
        if (simple) {
            return address -> noProxyHosts.contains(address.getHostName()) || noProxyHosts.contains(address.getHostName() + ":" + address.getPort());
        }
        LinkedList<BiFunction<String, Integer, Boolean>> hostMatchers = new LinkedList<BiFunction<String, Integer, Boolean>>();
        LinkedList<BiFunction<String, Integer, Boolean>> ipMatchers = new LinkedList<BiFunction<String, Integer, Boolean>>();
        Iterator<String> iterator = noProxyHosts.iterator();
        while (iterator.hasNext()) {
            String noProxyHost;
            String hostPart = noProxyHost = iterator.next();
            Integer portPart = null;
            Matcher portMatcher = PORT_PATTERN.matcher(noProxyHost);
            if (portMatcher.matches()) {
                portPart = Integer.parseInt(portMatcher.group(1));
                int index = noProxyHost.lastIndexOf(58);
                hostPart = noProxyHost.substring(0, index);
            }
            if (Proxy.isIpV4(hostPart)) {
                Proxy.exactMatch(ipMatchers, hostPart, portPart);
                continue;
            }
            if (Proxy.isIpV6Identifier(hostPart)) {
                if ("[::1]".equals(hostPart)) {
                    Proxy.exactMatch(ipMatchers, "0:0:0:0:0:0:0:1", portPart);
                }
                Proxy.exactMatch(ipMatchers, hostPart.substring(1, hostPart.length() - 1), portPart);
                continue;
            }
            if (hostPart.charAt(0) == '.') {
                Proxy.prefixedMatch(hostMatchers, hostPart, portPart);
                continue;
            }
            Proxy.exactMatch(hostMatchers, hostPart, portPart);
        }
        return address -> {
            Set<String> toCheck;
            InetAddress inetAddress = address.getAddress();
            if (inetAddress == null) {
                toCheck = Set.of(address.getHostString());
            } else {
                toCheck = new HashSet<String>();
                toCheck.add(Proxy.resolveHost(inetAddress.getHostName()));
                toCheck.add(Proxy.resolveHost(inetAddress.getHostAddress()));
            }
            int port = address.getPort();
            for (String host : toCheck) {
                if (Proxy.isIpV4(host) || Proxy.isIpV6Host(host)) {
                    for (BiFunction ipMatcher : ipMatchers) {
                        if (!((Boolean)ipMatcher.apply(host, port)).booleanValue()) continue;
                        LOGGER.log(System.Logger.Level.TRACE, () -> "IP Address " + host + " bypasses proxy");
                        return true;
                    }
                    LOGGER.log(System.Logger.Level.TRACE, () -> "IP Address " + host + " uses proxy");
                    continue;
                }
                for (BiFunction hostMatcher : hostMatchers) {
                    if (!((Boolean)hostMatcher.apply(host, port)).booleanValue()) continue;
                    LOGGER.log(System.Logger.Level.TRACE, () -> "Host " + host + " bypasses proxy");
                    return true;
                }
                LOGGER.log(System.Logger.Level.TRACE, () -> "Host " + host + " uses proxy");
            }
            return false;
        };
    }

    public Socket tcpSocket(WebClient webClient, InetSocketAddress inetSocketAddress, SocketOptions socketOptions, boolean tls) {
        return this.type.connect(webClient, this, inetSocketAddress, socketOptions, tls);
    }

    public ProxyType type() {
        return this.type;
    }

    public boolean isNoHosts(InetSocketAddress uri) {
        return this.noProxy.apply(uri);
    }

    public boolean isUsingSystemProxy(String uri) {
        if (this.systemProxySelector != null) {
            List<java.net.Proxy> proxies = this.systemProxySelector.select(URI.create(uri));
            return !proxies.isEmpty() && !proxies.get(0).equals(java.net.Proxy.NO_PROXY);
        }
        return false;
    }

    private Optional<InetSocketAddress> address(InetSocketAddress uri) {
        if (this.type == null || this.type == ProxyType.NONE || this.type == ProxyType.SYSTEM) {
            return Optional.empty();
        }
        if (this.isNoHosts(uri)) {
            return Optional.empty();
        }
        return Optional.of(new InetSocketAddress(this.host, this.port));
    }

    public int port() {
        return this.port;
    }

    public String host() {
        return this.host;
    }

    public Optional<String> username() {
        return this.username;
    }

    public Optional<char[]> password() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        return this.port == proxy.port && this.type == proxy.type && Objects.equals(this.systemProxySelector, proxy.systemProxySelector) && Objects.equals(this.host, proxy.host) && Objects.equals(this.noProxy, proxy.noProxy) && Objects.equals(this.username, proxy.username) && Objects.equals(this.password, proxy.password);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.host, this.port, this.noProxy, this.username, this.password});
    }

    private static String resolveHost(String host) {
        if (host != null && Proxy.isIpV6Identifier(host)) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    private static void prefixedMatch(List<BiFunction<String, Integer, Boolean>> matchers, String hostPart, Integer portPart) {
        if (null == portPart) {
            matchers.add((host, port) -> Proxy.prefixHostMatch(hostPart, host));
        } else {
            matchers.add((host, port) -> portPart.equals(port) && Proxy.prefixHostMatch(hostPart, host));
        }
    }

    private static boolean prefixHostMatch(String hostPart, String host) {
        if (host.endsWith(hostPart)) {
            return true;
        }
        return host.equals(hostPart.substring(1));
    }

    private static void exactMatch(List<BiFunction<String, Integer, Boolean>> matchers, String hostPart, Integer portPart) {
        if (null == portPart) {
            matchers.add((host, port) -> hostPart.equals(host));
        } else {
            matchers.add((host, port) -> portPart.equals(port) && hostPart.equals(host));
        }
    }

    private static boolean isIpV4(String host) {
        return IP_V4.matcher(host).matches();
    }

    private static boolean isIpV6Identifier(String host) {
        return IVP6_IDENTIFIER_MATCH_RESULTS.computeValue((Object)host, () -> Proxy.isIpV6IdentifierRegExp(host)).orElse(false);
    }

    private static Optional<Boolean> isIpV6IdentifierRegExp(String host) {
        return Optional.of(IP_V6_IDENTIFIER.matcher(host).matches() || IP_V6_HEX_IDENTIFIER.matcher(host).matches());
    }

    private static boolean isIpV6Host(String host) {
        return IVP6_HOST_MATCH_RESULTS.computeValue((Object)host, () -> Proxy.isIpV6HostRegExp(host)).orElse(false);
    }

    private static Optional<Boolean> isIpV6HostRegExp(String host) {
        return Optional.of(IP_V6_HOST.matcher(host).matches() || IP_V6_HEX_HOST.matcher(host).matches());
    }

    private static Socket connectToProxy(WebClient webClient, InetSocketAddress proxyAddress, InetSocketAddress targetAddress, Proxy proxy) {
        WebClientConfig clientConfig = (WebClientConfig)webClient.prototype();
        TcpClientConnection connection = TcpClientConnection.create(webClient, new ConnectionKey("http", proxyAddress.getHostName(), proxyAddress.getPort(), NO_TLS, clientConfig.dnsResolver(), clientConfig.dnsAddressLookup(), NO_PROXY), List.of(), it -> false, it -> {}).connect();
        HttpClientRequest request = (HttpClientRequest)((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)webClient.method(Method.CONNECT)).followRedirects(false)).connection(connection)).uri("http://" + proxyAddress.getHostName() + ":" + proxyAddress.getPort())).protocolId("http/1.1").header(HeaderNames.HOST, targetAddress.getHostName() + ":" + targetAddress.getPort())).accept(MediaTypes.WILDCARD);
        if (clientConfig.keepAlive()) {
            ((HttpClientRequest)request.header(HeaderValues.CONNECTION_KEEP_ALIVE)).header(PROXY_CONNECTION);
        }
        proxy.proxyAuthHeader.ifPresent(request::header);
        Object response = request.request();
        if (response.status().family() != Status.Family.SUCCESSFUL) {
            response.close();
            throw new IllegalStateException("Proxy sent wrong HTTP response code: " + String.valueOf(response.status()));
        }
        return connection.socket();
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<Builder, Proxy> {
        private final Set<String> noProxyHosts = new HashSet<String>();
        private ProxyType type = ProxyType.SYSTEM;
        private String host;
        private int port = 80;
        private String username;
        private char[] password;

        private Builder() {
        }

        public Proxy build() {
            return new Proxy(this);
        }

        public Builder config(Config config) {
            config.get("type").asString().map(ProxyType::valueOf).ifPresent(this::type);
            if (this.type != ProxyType.SYSTEM && this.type != ProxyType.NONE) {
                config.get("host").asString().ifPresent(this::host);
                config.get("port").asInt().ifPresent(this::port);
                config.get("username").asString().ifPresent(this::username);
                config.get("password").asString().map(String::toCharArray).ifPresent(this::password);
                config.get("no-proxy").asList(String.class).ifPresent(hosts -> hosts.forEach(this::addNoProxy));
            }
            return this;
        }

        @ConfiguredOption(value="HTTP")
        public Builder type(ProxyType type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        @ConfiguredOption
        public Builder host(String host) {
            this.host = Objects.requireNonNull(host);
            return this;
        }

        @ConfiguredOption
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @ConfiguredOption
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @ConfiguredOption(type=String.class)
        public Builder password(char[] password) {
            this.password = Arrays.copyOf(password, password.length);
            return this;
        }

        @ConfiguredOption(key="no-proxy", kind=ConfiguredOption.Kind.LIST)
        public Builder addNoProxy(String noProxyHost) {
            this.noProxyHosts.add(noProxyHost);
            return this;
        }

        ProxyType type() {
            return this.type;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }

        Set<String> noProxyHosts() {
            return new HashSet<String>(this.noProxyHosts);
        }

        Optional<String> username() {
            return Optional.ofNullable(this.username);
        }

        Optional<char[]> password() {
            return Optional.ofNullable(this.password);
        }
    }

    public static enum ProxyType {
        NONE{

            @Override
            Socket connect(WebClient webClient, Proxy proxy, InetSocketAddress targetAddress, SocketOptions socketOptions, boolean tls) {
                try {
                    Socket socket = new Socket();
                    socketOptions.configureSocket(socket);
                    socket.connect(targetAddress, (int)socketOptions.connectTimeout().toMillis());
                    return socket;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        ,
        SYSTEM{

            @Override
            Socket connect(WebClient webClient, Proxy proxy, InetSocketAddress targetAddress, SocketOptions socketOptions, boolean tls) {
                String scheme;
                String string = scheme = tls ? "https" : "http";
                if (proxy.systemProxySelector == null) {
                    return NONE.connect(webClient, proxy, targetAddress, socketOptions, tls);
                }
                List<java.net.Proxy> proxies = proxy.systemProxySelector.select(URI.create(scheme + "://" + targetAddress.getHostName() + ":" + targetAddress.getPort()));
                if (proxies.isEmpty()) {
                    return NONE.connect(webClient, proxy, targetAddress, socketOptions, tls);
                }
                try {
                    Socket socket = new Socket(proxies.get(0));
                    socketOptions.configureSocket(socket);
                    socket.connect(targetAddress, (int)socketOptions.connectTimeout().toMillis());
                    return socket;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        ,
        HTTP{

            @Override
            Socket connect(WebClient webClient, Proxy proxy, InetSocketAddress targetAddress, SocketOptions socketOptions, boolean tls) {
                return proxy.address(targetAddress).map(proxyAddress -> Proxy.connectToProxy(webClient, proxyAddress, targetAddress, proxy)).orElseGet(() -> NONE.connect(webClient, proxy, targetAddress, socketOptions, tls));
            }
        };


        abstract Socket connect(WebClient var1, Proxy var2, InetSocketAddress var3, SocketOptions var4, boolean var5);
    }
}

