/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import io.helidon.service.codegen.FieldHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class FieldHandlerImpl
implements FieldHandler {
    private final ClassModel.Builder classModel;
    private final Constructor.Builder constructor;
    private final Map<String, PrefixedConstants> constants = new HashMap<String, PrefixedConstants>();
    private final Map<String, PrefixedFields> fields = new HashMap<String, PrefixedFields>();

    FieldHandlerImpl(ClassModel.Builder classModel, Constructor.Builder constructor) {
        this.classModel = classModel;
        this.constructor = constructor;
    }

    @Override
    public String constant(String constantNamePrefix, TypeName constantType, Object uniqueIdentifier, Consumer<ContentBuilder<?>> contentBuilder) {
        return this.constants.computeIfAbsent(constantNamePrefix, it -> new PrefixedConstants(this.classModel, constantNamePrefix)).constant(constantType, uniqueIdentifier, contentBuilder);
    }

    @Override
    public String field(TypeName typeName, String fieldName, AccessModifier modifier, Object uniqueIdentifier, Consumer<ContentBuilder<?>> fieldUpdater, BiConsumer<Constructor.Builder, String> constructorUpdater) {
        return this.fields.computeIfAbsent(fieldName, it -> new PrefixedFields(this.classModel, this.constructor, fieldName)).field(typeName, modifier, uniqueIdentifier, fieldUpdater, constructorUpdater);
    }

    private static class PrefixedConstants {
        private final ClassModel.Builder classModel;
        private final String constantNamePrefix;
        private final AtomicInteger counter = new AtomicInteger();
        private final Map<UniqueIdentifier, String> existingConstants = new HashMap<UniqueIdentifier, String>();

        private PrefixedConstants(ClassModel.Builder classModel, String constantNamePrefix) {
            this.classModel = classModel;
            this.constantNamePrefix = constantNamePrefix;
        }

        public String constant(TypeName constantType, Object uniqueIdentifier, Consumer<ContentBuilder<?>> contentBuilder) {
            UniqueIdentifier ui = new UniqueIdentifier(uniqueIdentifier, constantType);
            return this.existingConstants.computeIfAbsent(ui, it -> {
                int nextId = this.counter.getAndIncrement();
                Object name = nextId == 0 && !this.constantNamePrefix.endsWith("_") ? this.constantNamePrefix : this.constantNamePrefix + "_" + nextId;
                this.classModel.addField(arg_0 -> PrefixedConstants.lambda$constant$0((String)name, constantType, contentBuilder, arg_0));
                return name;
            });
        }

        private static /* synthetic */ void lambda$constant$0(String name, TypeName constantType, Consumer contentBuilder, Field.Builder newConstant) {
            ((Field.Builder)newConstant.name(name)).type(constantType).accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).update(contentBuilder::accept);
        }
    }

    private static class PrefixedFields {
        private final ClassModel.Builder classModel;
        private final Constructor.Builder constructor;
        private final String fieldNamePrefix;
        private final AtomicInteger counter = new AtomicInteger();
        private final Map<UniqueIdentifier, String> existingFields = new HashMap<UniqueIdentifier, String>();
        private final boolean suffixed;

        private PrefixedFields(ClassModel.Builder classModel, Constructor.Builder constructor, String fieldNamePrefix) {
            this.classModel = classModel;
            this.constructor = constructor;
            this.fieldNamePrefix = fieldNamePrefix;
            this.suffixed = fieldNamePrefix.endsWith("_");
        }

        private String field(TypeName typeName, AccessModifier modifier, Object uniqueIdentifier, Consumer<ContentBuilder<?>> fieldUpdater, BiConsumer<Constructor.Builder, String> constructorUpdater) {
            UniqueIdentifier ui = new UniqueIdentifier(uniqueIdentifier, typeName);
            return this.existingFields.computeIfAbsent(ui, it -> {
                int nextId = this.counter.getAndIncrement();
                Object name = nextId == 0 && !this.suffixed ? this.fieldNamePrefix : (this.suffixed ? this.fieldNamePrefix + nextId : this.fieldNamePrefix + "_" + nextId);
                this.classModel.addField(arg_0 -> PrefixedFields.lambda$field$0((String)name, modifier, typeName, fieldUpdater, arg_0));
                constructorUpdater.accept(this.constructor, (String)name);
                return name;
            });
        }

        private static /* synthetic */ void lambda$field$0(String name, AccessModifier modifier, TypeName typeName, Consumer fieldUpdater, Field.Builder field) {
            ((Field.Builder)field.name(name)).accessModifier(modifier).isFinal(true).type(typeName).update(fieldUpdater::accept);
        }
    }

    private record UniqueIdentifier(Object uniqueIdentifier, TypeName typeName) {
    }
}

