/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.codegen.DescribedElements;
import io.helidon.service.codegen.DescribedType;
import io.helidon.service.codegen.FactoryType;
import io.helidon.service.codegen.InterceptionSupport;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenAnnotations;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceContracts;
import io.helidon.service.codegen.ServiceSuperType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class DescribedService {
    private final DescribedType serviceType;
    private final DescribedType providedType;
    private final FactoryType providerType;
    private final Set<Annotation> qualifiers;
    private final TypeName descriptorType;
    private final TypeName scope;
    private final ServiceSuperType superType;
    private final TypeName qualifiedProviderQualifier;

    private DescribedService(DescribedType serviceType, DescribedType providedType, ServiceSuperType superType, TypeName scope, TypeName descriptorType, Set<Annotation> qualifiers, FactoryType providerType, TypeName qualifiedProviderQualifier) {
        this.serviceType = serviceType;
        this.providedType = providedType;
        this.superType = superType;
        this.descriptorType = descriptorType;
        this.scope = scope;
        this.qualifiers = Set.copyOf(qualifiers);
        this.providerType = providerType;
        this.qualifiedProviderQualifier = qualifiedProviderQualifier;
    }

    static DescribedService create(RegistryCodegenContext ctx, RegistryRoundContext roundContext, InterceptionSupport interception, TypeInfo serviceInfo, ServiceSuperType superType, TypeName scope) {
        DescribedType providedDescriptor;
        DescribedType serviceDescriptor;
        TypeName serviceType = serviceInfo.typeName();
        TypeName descriptorType = ctx.descriptorType(serviceType);
        HashSet<ResolvedType> directContracts = new HashSet<ResolvedType>();
        HashSet<ResolvedType> providedContracts = new HashSet<ResolvedType>();
        FactoryType providerType = FactoryType.SERVICE;
        TypeName qualifiedProviderQualifier = null;
        TypeInfo providedTypeInfo = null;
        TypeName providedTypeName = null;
        ServiceContracts serviceContracts = roundContext.serviceContracts(serviceInfo);
        if (serviceInfo.kind() == ElementKind.INTERFACE) {
            directContracts.add(ResolvedType.create((TypeName)serviceInfo.typeName()));
        }
        List typeInfos = serviceInfo.interfaceTypeInfo();
        HashMap<TypeName, TypeInfo> implementedInterfaceTypes = new HashMap<TypeName, TypeInfo>();
        typeInfos.forEach(it -> implementedInterfaceTypes.put(it.typeName(), (TypeInfo)it));
        ServiceContracts.FactoryAnalysis response = serviceContracts.analyseFactory(TypeNames.SUPPLIER);
        if (response.valid()) {
            providerType = FactoryType.SUPPLIER;
            directContracts.add(ResolvedType.create((TypeName)response.factoryType()));
            providedContracts.addAll(response.providedContracts());
            providedTypeName = response.providedType();
            providedTypeInfo = response.providedTypeInfo();
            implementedInterfaceTypes.remove(TypeNames.SUPPLIER);
        }
        if ((response = serviceContracts.analyseFactory(ServiceCodegenTypes.SERVICE_SERVICES_FACTORY)).valid()) {
            if (providerType != FactoryType.SERVICE) {
                throw new CodegenException("Service implements more than one provider type: " + String.valueOf((Object)providerType) + ", and services provider.", serviceInfo.originatingElementValue());
            }
            providerType = FactoryType.SERVICES;
            directContracts.add(ResolvedType.create((TypeName)response.providedType()));
            providedContracts.addAll(response.providedContracts());
            providedTypeName = response.providedType();
            providedTypeInfo = response.providedTypeInfo();
            implementedInterfaceTypes.remove(ServiceCodegenTypes.SERVICE_SERVICES_FACTORY);
        }
        if ((response = serviceContracts.analyseFactory(ServiceCodegenTypes.SERVICE_INJECTION_POINT_FACTORY)).valid()) {
            if (providerType != FactoryType.SERVICE) {
                throw new CodegenException("Service implements more than one provider type: " + String.valueOf((Object)providerType) + ", and injection point provider.", serviceInfo.originatingElementValue());
            }
            providerType = FactoryType.INJECTION_POINT;
            directContracts.add(ResolvedType.create((TypeName)response.providedType()));
            providedContracts.addAll(response.providedContracts());
            providedTypeName = response.providedType();
            providedTypeInfo = response.providedTypeInfo();
            implementedInterfaceTypes.remove(ServiceCodegenTypes.SERVICE_INJECTION_POINT_FACTORY);
        }
        if ((response = serviceContracts.analyseFactory(ServiceCodegenTypes.SERVICE_QUALIFIED_FACTORY)).valid()) {
            if (providerType != FactoryType.SERVICE) {
                throw new CodegenException("Service implements more than one provider type: " + String.valueOf((Object)providerType) + ", and qualified provider.", serviceInfo.originatingElementValue());
            }
            providerType = FactoryType.QUALIFIED;
            directContracts.add(ResolvedType.create((TypeName)response.providedType()));
            providedContracts.addAll(response.providedContracts());
            qualifiedProviderQualifier = ServiceContracts.requiredTypeArgument((TypeInfo)implementedInterfaceTypes.remove(ServiceCodegenTypes.SERVICE_QUALIFIED_FACTORY), 1);
            providedTypeName = response.providedType();
            providedTypeInfo = response.providedTypeInfo();
            implementedInterfaceTypes.remove(ServiceCodegenTypes.SERVICE_QUALIFIED_FACTORY);
        }
        HashSet processedDirectContracts = new HashSet();
        implementedInterfaceTypes.forEach((type, typeInfo) -> serviceContracts.addContracts((Set<ResolvedType>)directContracts, processedDirectContracts, (TypeInfo)typeInfo));
        serviceInfo.superTypeInfo().ifPresent(it -> serviceContracts.addContracts((Set<ResolvedType>)directContracts, processedDirectContracts, (TypeInfo)it));
        if (providerType == FactoryType.SERVICE) {
            DescribedElements serviceElements = DescribedElements.create(ctx, interception, directContracts, serviceInfo);
            serviceDescriptor = new DescribedType(serviceInfo, serviceInfo.typeName(), directContracts, serviceElements);
            providedDescriptor = null;
        } else {
            DescribedElements serviceElements = DescribedElements.create(ctx, interception, Set.of(), serviceInfo);
            serviceDescriptor = new DescribedType(serviceInfo, serviceInfo.typeName(), directContracts, serviceElements);
            DescribedElements providedElements = DescribedElements.create(ctx, interception, providedContracts, providedTypeInfo);
            providedDescriptor = new DescribedType(providedTypeInfo, providedTypeName, providedContracts, providedElements);
        }
        return new DescribedService(serviceDescriptor, providedDescriptor, superType, scope, descriptorType, DescribedService.gatherQualifiers(serviceInfo), providerType, qualifiedProviderQualifier);
    }

    public String toString() {
        return this.serviceType.typeName().fqName();
    }

    TypeName interceptionWrapperSuperType() {
        return switch (this.providerType()) {
            default -> throw new MatchException(null, null);
            case FactoryType.NONE, FactoryType.SERVICE -> this.serviceType.typeName();
            case FactoryType.SUPPLIER -> DescribedService.createType(ServiceCodegenTypes.INTERCEPT_G_WRAPPER_SUPPLIER_FACTORY, this.providedType.typeName());
            case FactoryType.SERVICES -> DescribedService.createType(ServiceCodegenTypes.INTERCEPT_G_WRAPPER_SERVICES_FACTORY, this.providedType.typeName());
            case FactoryType.INJECTION_POINT -> DescribedService.createType(ServiceCodegenTypes.INTERCEPT_G_WRAPPER_IP_FACTORY, this.providedType.typeName());
            case FactoryType.QUALIFIED -> DescribedService.createType(ServiceCodegenTypes.INTERCEPT_G_WRAPPER_QUALIFIED_FACTORY, this.providedType.typeName(), this.qualifiedProviderQualifier);
        };
    }

    TypeName providerInterface() {
        return switch (this.providerType()) {
            default -> throw new MatchException(null, null);
            case FactoryType.NONE, FactoryType.SERVICE -> this.serviceType.typeName();
            case FactoryType.SUPPLIER -> DescribedService.createType(TypeNames.SUPPLIER, this.providedType.typeName());
            case FactoryType.SERVICES -> DescribedService.createType(ServiceCodegenTypes.SERVICE_SERVICES_FACTORY, this.providedType.typeName());
            case FactoryType.INJECTION_POINT -> DescribedService.createType(ServiceCodegenTypes.SERVICE_INJECTION_POINT_FACTORY, this.providedType.typeName());
            case FactoryType.QUALIFIED -> DescribedService.createType(ServiceCodegenTypes.SERVICE_QUALIFIED_FACTORY, this.providedType.typeName(), this.qualifiedProviderQualifier);
        };
    }

    boolean isFactory() {
        return this.providerType() != FactoryType.SERVICE && this.providerType() != FactoryType.NONE;
    }

    DescribedType providedDescriptor() {
        return this.providedType;
    }

    DescribedType serviceDescriptor() {
        return this.serviceType;
    }

    ServiceSuperType superType() {
        return this.superType;
    }

    TypeName descriptorType() {
        return this.descriptorType;
    }

    TypeName scope() {
        return this.scope;
    }

    Set<Annotation> qualifiers() {
        return Set.copyOf(this.qualifiers);
    }

    FactoryType providerType() {
        return this.providerType;
    }

    TypeName qualifiedProviderQualifier() {
        return this.qualifiedProviderQualifier;
    }

    private static TypeName createType(TypeName ... types) {
        TypeName.Builder builder = (TypeName.Builder)TypeName.builder().from(types[0]);
        for (int i = 1; i < types.length; ++i) {
            builder.addTypeArgument(types[i]);
        }
        return builder.build();
    }

    private static Set<Annotation> gatherQualifiers(TypeInfo serviceTypeInfo) {
        LinkedHashSet<Annotation> qualifiers = new LinkedHashSet<Annotation>();
        if (serviceTypeInfo.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE)) {
            qualifiers.add(ServiceCodegenAnnotations.WILDCARD_NAMED);
        }
        for (Annotation annotation : serviceTypeInfo.annotations()) {
            if (annotation.hasMetaAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_QUALIFIER)) {
                qualifiers.add(annotation);
                continue;
            }
            if (!serviceTypeInfo.hasMetaAnnotation(annotation.typeName(), ServiceCodegenTypes.SERVICE_ANNOTATION_QUALIFIER)) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }
}

