/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;

final class ReflectionUtil {
    private ReflectionUtil() {
    }

    static boolean canAccess(Class<?> invoker, Member target) {
        return ReflectionUtil.checkAccess(invoker, target, null);
    }

    static boolean canAccess(Class<?> invoker, Member target, Object anInstance) {
        return ReflectionUtil.checkAccess(invoker, target, anInstance);
    }

    private static boolean checkAccess(Class<?> invoker, Member target, Object anInstance) {
        boolean isPackage;
        int modifiers = target.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        boolean isPublic = Modifier.isPublic(modifiers);
        boolean isProtected = Modifier.isProtected(modifiers);
        boolean isPrivate = Modifier.isPrivate(modifiers);
        boolean bl = isPackage = !isPrivate && !isProtected && !isPublic;
        if (isStatic && null != anInstance) {
            return false;
        }
        if (target instanceof Constructor && null != anInstance) {
            return false;
        }
        Class<?> targetClass = target.getDeclaringClass();
        if (null != anInstance && !targetClass.isAssignableFrom(anInstance.getClass())) {
            return false;
        }
        if (!isStatic && anInstance != null) {
            targetClass = anInstance.getClass();
        }
        if (invoker == targetClass) {
            return true;
        }
        if (!ReflectionUtil.checkAccess(invoker, targetClass)) {
            return false;
        }
        if (isPublic) {
            return true;
        }
        Class<?> invokerRoot = ReflectionUtil.getRoot(invoker);
        Class<?> targetRoot = ReflectionUtil.getRoot(targetClass);
        if (isProtected) {
            return ReflectionUtil.isProtected(invoker, targetClass);
        }
        if (isPackage) {
            return Objects.equals(invokerRoot.getPackage(), targetRoot.getPackage());
        }
        if (isPrivate) {
            return Objects.equals(invokerRoot, targetRoot);
        }
        return false;
    }

    private static boolean checkAccess(Class<?> invoker, Class<?> targetClass) {
        boolean isPackage;
        int modifiers = targetClass.getModifiers();
        boolean isPublic = Modifier.isPublic(modifiers);
        boolean isProtected = Modifier.isProtected(modifiers);
        boolean isPrivate = Modifier.isPrivate(modifiers);
        boolean bl = isPackage = !isPrivate && !isProtected && !isPublic;
        if (isPublic) {
            return true;
        }
        if (isProtected) {
            return ReflectionUtil.isProtected(invoker, targetClass);
        }
        Class<?> rootInvokerClass = ReflectionUtil.getRoot(invoker);
        Class<?> rootTargetClass = ReflectionUtil.getRoot(targetClass);
        if (!Objects.equals(rootInvokerClass.getPackage(), rootTargetClass.getPackage())) {
            return false;
        }
        if (isPackage) {
            return true;
        }
        if (isPrivate) {
            return rootInvokerClass == rootTargetClass;
        }
        return false;
    }

    private static boolean isProtected(Class<?> invoker, Class<?> targetClass) {
        Class<?> current = invoker;
        Class<?> targetRoot = ReflectionUtil.getRoot(targetClass);
        do {
            if (current != targetRoot) continue;
            return true;
        } while ((current = current.getEnclosingClass()) != null);
        current = invoker;
        do {
            if (current != targetRoot) continue;
            return true;
        } while ((current = current.getSuperclass()) != null);
        return false;
    }

    private static Class<?> getRoot(Class<?> invoker) {
        Class<?> result = invoker;
        while (result.getEnclosingClass() != null) {
            result = result.getEnclosingClass();
        }
        return result;
    }
}

