/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.spi;

import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.security.spi.ProviderConfig;
import io.helidon.security.spi.SecurityProvider;

public interface DigestProvider<T extends ProviderConfig>
extends SecurityProvider {
    public DigestSupport digest(Config var1);

    public DigestSupport digest(T var1);

    public static class DigestSupport {
        private final DigestFunction digestFunction;
        private final VerifyFunction verifyFunction;

        protected DigestSupport(DigestFunction digestFunction, VerifyFunction verifyFunction) {
            this.digestFunction = digestFunction;
            this.verifyFunction = verifyFunction;
        }

        public static DigestSupport create(DigestFunction digestFunction, VerifyFunction verifyFunction) {
            return new DigestSupport(digestFunction, verifyFunction);
        }

        public Single<String> digest(byte[] bytes, boolean preHashed) {
            return this.digestFunction.apply(bytes, preHashed);
        }

        public Single<Boolean> verify(byte[] bytes, boolean preHashed, String digest) {
            return this.verifyFunction.apply(bytes, preHashed, digest);
        }
    }

    @FunctionalInterface
    public static interface VerifyFunction {
        public Single<Boolean> apply(byte[] var1, Boolean var2, String var3);
    }

    @FunctionalInterface
    public static interface DigestFunction {
        public Single<String> apply(byte[] var1, Boolean var2);
    }
}

