/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import io.helidon.security.AuditEvent;
import io.helidon.security.spi.AuditProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DefaultAuditProvider
implements AuditProvider {
    private final Logger auditLogger;

    private DefaultAuditProvider(String loggerName) {
        this.auditLogger = Logger.getLogger(loggerName);
    }

    public static DefaultAuditProvider create(Config config) {
        return new DefaultAuditProvider((String)config.get("security.audit.defaultProvider.logger").asString().orElse((Object)"AUDIT"));
    }

    @Override
    public Consumer<AuditProvider.TracedAuditEvent> auditConsumer() {
        return this::audit;
    }

    private void audit(AuditProvider.TracedAuditEvent event) {
        String tracingId = event.tracingId();
        switch (event.severity()) {
            case FAILURE: 
            case SUCCESS: 
            case INFO: {
                this.logEvent(tracingId, event, Level.FINEST);
                break;
            }
            case WARN: {
                this.logEvent(tracingId, event, Level.WARNING);
                break;
            }
            case ERROR: {
                this.logEvent(tracingId, event, Level.SEVERE);
                break;
            }
            default: {
                this.logEvent(tracingId, event, Level.SEVERE);
            }
        }
    }

    private void logEvent(String tracingId, AuditProvider.TracedAuditEvent event, Level level) {
        AuditProvider.AuditSource auditSource = event.auditSource();
        StringBuilder locationInfo = new StringBuilder();
        locationInfo.append(auditSource.className().orElse("UnknownClass")).append(" ").append(auditSource.methodName().orElse("UnknownMethod")).append(" ").append(auditSource.fileName().orElse("UnknownFile")).append(" ").append(auditSource.lineNumber().orElse(-1));
        Object msg = event.severity() + " " + event.eventType() + " " + tracingId + " " + event.getClass().getSimpleName() + " " + locationInfo + " :: \"" + this.formatMessage(event) + "\"";
        Object finalMsg = msg = ((String)msg).replace('\n', ' ');
        event.throwable().ifPresentOrElse(arg_0 -> this.lambda$logEvent$0(level, (String)finalMsg, arg_0), () -> this.lambda$logEvent$1(level, (String)finalMsg));
    }

    String formatMessage(AuditEvent event) {
        try {
            return String.format(event.messageFormat(), this.toObjectParams(event.params()));
        }
        catch (Exception e) {
            return "Formatting failed for format: " + event.messageFormat() + ", parameters: " + event.params();
        }
    }

    private Object[] toObjectParams(List<AuditEvent.AuditParam> parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (AuditEvent.AuditParam param : parameters) {
            if (param.isSensitive()) {
                result.add("(sensitive)");
                continue;
            }
            result.add(param.value().orElse("null"));
        }
        return result.toArray(new Object[0]);
    }

    private /* synthetic */ void lambda$logEvent$1(Level level, String finalMsg) {
        this.auditLogger.log(level, finalMsg);
    }

    private /* synthetic */ void lambda$logEvent$0(Level level, String finalMsg, Throwable throwable) {
        this.auditLogger.log(level, finalMsg, throwable);
    }
}

