/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.OpenApiService;
import io.helidon.openapi.spi.OpenApiManagerProvider;
import io.helidon.openapi.spi.OpenApiServiceProvider;
import io.helidon.webserver.spi.ServerFeatureProvider;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint
@Configured(root=true, prefix="openapi")
@Prototype.Provides(value={ServerFeatureProvider.class})
interface OpenApiFeatureConfigBlueprint
extends Prototype.Factory<OpenApiFeature> {
    @Option.DefaultDouble(value={90.0})
    @Option.Configured
    public double weight();

    @ConfiguredOption(key="enabled", value="true")
    public boolean isEnabled();

    @ConfiguredOption(value="/openapi")
    public String webContext();

    @ConfiguredOption
    public Optional<String> staticFile();

    @ConfiguredOption
    public Optional<CrossOriginConfig> cors();

    @ConfiguredOption(provider=true, providerType=OpenApiServiceProvider.class)
    @Option.Singular
    public List<OpenApiService> services();

    @ConfiguredOption(provider=true, providerType=OpenApiManagerProvider.class, providerDiscoverServices=false)
    public Optional<OpenApiManager<?>> manager();

    @ConfiguredOption
    @Option.DefaultBoolean(value={true})
    public boolean permitAll();

    @ConfiguredOption
    @Option.Default(value={"openapi"})
    public List<String> roles();

    @Option.Default(value={"openapi"})
    public String name();

    @Option.Configured
    @Option.Singular
    public Set<String> sockets();
}

