/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.openapi.OpenApiFeature;
import java.util.Objects;

public class OpenApiStaticFile {
    private OpenApiFeature.OpenAPIMediaType openApiMediaType;
    private String content;

    static OpenApiStaticFile create(OpenApiFeature.OpenAPIMediaType openApiMediaType, String content) {
        return new Builder().openApiMediaType(openApiMediaType).content(content).build();
    }

    private OpenApiStaticFile(Builder builder) {
        this.content = builder.content;
        this.openApiMediaType = builder.openApiMediaType;
    }

    public OpenApiFeature.OpenAPIMediaType openApiMediaType() {
        return this.openApiMediaType;
    }

    public String content() {
        return this.content;
    }

    void content(String content) {
        this.content = content;
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, OpenApiStaticFile> {
        private OpenApiFeature.OpenAPIMediaType openApiMediaType;
        private String content;

        Builder() {
        }

        public OpenApiStaticFile build() {
            Objects.requireNonNull(this.openApiMediaType, "openApiMediaType");
            Objects.requireNonNull(this.content, "content");
            return new OpenApiStaticFile(this);
        }

        Builder openApiMediaType(OpenApiFeature.OpenAPIMediaType openApiMediaType) {
            this.openApiMediaType = openApiMediaType;
            return this;
        }

        Builder content(String content) {
            this.content = content;
            return this;
        }
    }
}

