/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.HttpMediaType;
import io.helidon.common.media.type.MediaType;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.nima.webserver.http.HttpService;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.openapi.OpenApiUiBase;
import java.util.Map;
import java.util.function.Function;

public interface OpenApiUi
extends HttpService {
    public static final String UI_WEB_SUBCONTEXT = "/ui";

    public static Builder<?, ?> builder() {
        return OpenApiUiBase.builder();
    }

    public HttpMediaType[] supportedMediaTypes();

    public boolean prepareTextResponseFromMainEndpoint(ServerRequest var1, ServerResponse var2);

    @Configured(prefix="ui")
    public static interface Builder<B extends Builder<B, T>, T extends OpenApiUi>
    extends io.helidon.common.Builder<B, T> {
        public static final String OPENAPI_UI_CONFIG_KEY = "ui";
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String OPTIONS_CONFIG_KEY = "options";
        public static final String WEB_CONTEXT_CONFIG_KEY = "web-context";

        @ConfiguredOption(kind=ConfiguredOption.Kind.MAP)
        public B options(Map<String, String> var1);

        @ConfiguredOption(key="enabled", value="true")
        public B isEnabled(boolean var1);

        @ConfiguredOption(description="web context (path) where the UI will respond")
        public B webContext(String var1);

        default public B config(Config uiConfig) {
            uiConfig.get(ENABLED_CONFIG_KEY).asBoolean().ifPresent(this::isEnabled);
            uiConfig.get(WEB_CONTEXT_CONFIG_KEY).asString().ifPresent(this::webContext);
            uiConfig.get(OPTIONS_CONFIG_KEY).detach().asMap().ifPresent(this::options);
            return (B)this.identity();
        }

        default public B identity() {
            return (B)this;
        }

        public B documentPreparer(Function<MediaType, String> var1);

        public B openApiSupportWebContext(String var1);

        default public OpenApiUi build(Function<MediaType, String> documentPreparer, String openAPIWebContext) {
            this.documentPreparer(documentPreparer);
            this.openApiSupportWebContext(openAPIWebContext);
            return (OpenApiUi)this.build();
        }
    }
}

