/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.UncheckedException;
import io.helidon.microprofile.testing.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import sun.misc.Unsafe;

public interface Instrumented {
    public static <T> T allocateInstance(Class<T> type) {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Unsafe unsafe = (Unsafe)field.get(null);
            return type.cast(unsafe.allocateInstance(type));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInstrumented(Class<?> type) {
        for (Class<?> iface : type.getInterfaces()) {
            if (!iface.equals(Instrumented.class)) continue;
            return true;
        }
        return false;
    }

    public static <T> Class<? extends T> instrument(Class<T> type, List<Annotation> annotations, List<Class<? extends Annotation>> methodExcludes, BiFunction<Class<T>, Method, T> resolver) {
        return Instrumented.instrument(type, annotations, methodExcludes, (Object proxy, Method method, Object[] args) -> {
            Object instance = resolver.apply(type, method);
            if (instance != null) {
                try {
                    return ReflectionHelper.invoke(Object.class, method, instance, args);
                }
                catch (UncheckedException e) {
                    Throwable patt0$temp = e.getCause();
                    if (patt0$temp instanceof InvocationTargetException) {
                        InvocationTargetException te = (InvocationTargetException)patt0$temp;
                        throw te;
                    }
                    throw e;
                }
            }
            return null;
        });
    }

    public static <T> Class<? extends T> instrument(Class<T> type, List<Annotation> annotations, List<Class<? extends Annotation>> methodExcludes, InvocationHandler handler) {
        Class clazz;
        block9: {
            ElementMatcher.Junction matcher = ElementMatchers.not((ElementMatcher)ElementMatchers.isEquals()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isHashCode())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isToString()));
            for (Class<? extends Annotation> exclude : methodExcludes) {
                matcher = matcher.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith(exclude)));
            }
            DynamicType.Unloaded unloaded = new ByteBuddy().subclass(type, ConstructorStrategy.Default.IMITATE_SUPER_CLASS.withInheritedAnnotations()).implement(new Type[]{Instrumented.class}).annotateType((Annotation[])Stream.concat(Arrays.stream(type.getDeclaredAnnotations()), annotations.stream()).toArray(Annotation[]::new)).withHashCodeEquals().method((ElementMatcher)matcher).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)handler)).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).make();
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
                clazz = unloaded.load(type.getClassLoader(), ClassLoadingStrategy.UsingLookup.of((Object)lookup)).getLoaded();
                if (unloaded == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (unloaded != null) {
                        try {
                            unloaded.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            unloaded.close();
        }
        return clazz;
    }
}

