/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.testng.ClassContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.xml.XmlTest;

abstract class HelidonTestNgListenerBase
implements IInvokedMethodListener,
IConfigurationListener,
IClassListener {
    private static final Map<XmlTest, Map<ITestClass, ClassContext>> CONTEXTS = new ConcurrentHashMap<XmlTest, Map<ITestClass, ClassContext>>();
    private static final Semaphore SEMAPHORE = new Semaphore(1);

    HelidonTestNgListenerBase() {
    }

    abstract boolean filterClass(Class<?> var1);

    abstract void onBeforeInvocation(ClassContext var1, HelidonTestInfo.MethodInfo var2, HelidonTestInfo<?> var3);

    abstract void onAfterInvocation(HelidonTestInfo.MethodInfo var1, HelidonTestInfo<?> var2, boolean var3);

    abstract void onBeforeClass(HelidonTestInfo.ClassInfo var1);

    abstract void onAfterClass(HelidonTestInfo.ClassInfo var1);

    public void onConfigurationFailure(ITestResult tr, ITestNGMethod tm) {
        if (this.filterClass(HelidonTestNgListenerBase.realClass(tr))) {
            ITestNGMethod im = tr.getMethod();
            this.classContext(im.getTestClass()).afterInvocation(im, tm);
        }
    }

    public void onConfigurationSuccess(ITestResult tr, ITestNGMethod tm) {
        if (this.filterClass(HelidonTestNgListenerBase.realClass(tr))) {
            ITestNGMethod im = tr.getMethod();
            this.classContext(im.getTestClass()).afterInvocation(im, tm);
        }
    }

    public void beforeConfiguration(ITestResult tr, ITestNGMethod tm) {
        if (this.filterClass(HelidonTestNgListenerBase.realClass(tr))) {
            ITestNGMethod im = tr.getMethod();
            this.classContext(im.getTestClass()).beforeInvocation(im, tm);
        }
    }

    public void beforeInvocation(IInvokedMethod im, ITestResult tr) {
        if (this.filterClass(HelidonTestNgListenerBase.realClass(tr)) && im.isTestMethod()) {
            ITestNGMethod tm = im.getTestMethod();
            this.classContext(tm.getTestClass()).beforeInvocation(tm, tm);
        }
    }

    public void afterInvocation(IInvokedMethod im, ITestResult tr) {
        if (this.filterClass(HelidonTestNgListenerBase.realClass(tr)) && im.isTestMethod()) {
            ITestNGMethod tm = im.getTestMethod();
            this.classContext(tm.getTestClass()).afterInvocation(tm, tm);
        }
    }

    public void onBeforeClass(ITestClass tc) {
        Class cls = tc.getRealClass();
        if (this.filterClass(cls)) {
            this.classContext(tc).beforeClass();
        }
    }

    public void onAfterClass(ITestClass tc) {
        if (this.filterClass(tc.getRealClass())) {
            this.classContext(tc).afterClass();
        }
    }

    private ClassContext classContext(ITestClass tc) {
        return CONTEXTS.computeIfAbsent(tc.getXmlTest(), k -> new ConcurrentHashMap()).computeIfAbsent(tc, k -> new ClassContext((ITestClass)k, SEMAPHORE, this));
    }

    private static Class<?> realClass(ITestResult tr) {
        return tr.getTestClass().getRealClass();
    }
}

