/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.testng.HelidonTestDescriptorImpl;
import io.helidon.microprofile.testing.testng.HelidonTestNgListenerBase;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;

class ClassContext {
    private final Semaphore semaphore;
    private final HelidonTestNgListenerBase listener;
    private final HelidonTestInfo.ClassInfo classInfo;
    private final List<HelidonTestInfo.MethodInfo> methods;
    private final AtomicInteger invocationCount = new AtomicInteger();
    private final AtomicBoolean afterClass = new AtomicBoolean();
    private final Map<HelidonTestInfo<?>, List<HelidonTestInfo.MethodInfo>> graph = new ConcurrentHashMap();
    private final Map<Object, CompletableFuture<Void>> methodsFutures = new ConcurrentHashMap<Object, CompletableFuture<Void>>();

    ClassContext(ITestClass tc, Semaphore semaphore, HelidonTestNgListenerBase listener) {
        this.listener = listener;
        this.semaphore = semaphore;
        this.classInfo = ClassContext.classInfo(tc.getRealClass());
        this.methods = ClassContext.methodInfos(this.classInfo, tc.getTestMethods(), tc.getBeforeTestMethods(), tc.getBeforeTestMethods(), tc.getBeforeClassMethods(), tc.getAfterClassMethods());
    }

    void awaitMethods() {
        try {
            for (CompletableFuture<Void> future : Set.copyOf(this.methodsFutures.values())) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    void beforeInvocation(ITestNGMethod invokedMethod, ITestNGMethod testMethod) {
        HelidonTestInfo.MethodInfo methodInfo = ClassContext.methodInfo(this.classInfo, ClassContext.realMethod(invokedMethod));
        HelidonTestInfo.ClassInfo testInfo = testMethod != null ? ClassContext.methodInfo(this.classInfo, ClassContext.realMethod(testMethod)) : this.classInfo;
        this.graph.compute((HelidonTestInfo<?>)testInfo, (BiFunction<HelidonTestInfo<?>, List<HelidonTestInfo.MethodInfo>, List<HelidonTestInfo.MethodInfo>>)((BiFunction<HelidonTestInfo, List, List>)(k, v) -> {
            if (v == null) {
                v = new ArrayList<HelidonTestInfo.MethodInfo>();
            }
            v.add(methodInfo);
            return v;
        }));
        this.listener.onBeforeInvocation(this, methodInfo, (HelidonTestInfo<?>)testInfo);
        if (invokedMethod.isTest()) {
            this.methodsFutures.put(methodInfo, new CompletableFuture());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterInvocation(ITestNGMethod invokedMethod, ITestNGMethod testMethod) {
        try {
            HelidonTestInfo.MethodInfo methodInfo = ClassContext.methodInfo(this.classInfo, ClassContext.realMethod(invokedMethod));
            HelidonTestInfo.ClassInfo testInfo = testMethod != null ? ClassContext.methodInfo(this.classInfo, ClassContext.realMethod(testMethod)) : this.classInfo;
            List deps = this.graph.compute((HelidonTestInfo<?>)testInfo, (BiFunction<HelidonTestInfo<?>, List<HelidonTestInfo.MethodInfo>, List<HelidonTestInfo.MethodInfo>>)((BiFunction<HelidonTestInfo, List, List>)(k, v) -> {
                if (v == null) {
                    v = new ArrayList();
                }
                v.remove(methodInfo);
                return v;
            }));
            boolean last = deps.isEmpty();
            this.listener.onAfterInvocation(methodInfo, (HelidonTestInfo<?>)testInfo, last);
            CompletableFuture<Void> future = this.methodsFutures.get(methodInfo);
            if (future != null) {
                future.complete(null);
            }
        }
        finally {
            this.afterClass(AtomicInteger::incrementAndGet);
        }
    }

    void beforeClass() {
        try {
            this.semaphore.acquire();
            this.listener.onBeforeClass(this.classInfo);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void afterClass() {
        this.afterClass(AtomicInteger::get);
    }

    public String toString() {
        return "ClassContext{class=" + ((Class)this.classInfo.element()).getName() + ", methods: " + ClassContext.methodNames(this.methods) + "}";
    }

    private void afterClass(Function<AtomicInteger, Integer> op) {
        if (op.apply(this.invocationCount).intValue() == this.methods.size() && this.afterClass.compareAndSet(false, true)) {
            try {
                this.listener.onAfterClass(this.classInfo);
                this.methodsFutures.clear();
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    static HelidonTestInfo.ClassInfo classInfo(Class<?> cls) {
        return HelidonTestInfo.classInfo(cls, HelidonTestDescriptorImpl::new);
    }

    static HelidonTestInfo.MethodInfo methodInfo(HelidonTestInfo.ClassInfo classInfo, Method method) {
        return HelidonTestInfo.methodInfo((Method)method, (HelidonTestInfo.ClassInfo)classInfo, HelidonTestDescriptorImpl::new);
    }

    private static List<HelidonTestInfo.MethodInfo> methodInfos(HelidonTestInfo.ClassInfo classInfo, ITestNGMethod[] ... methods) {
        return Stream.of(methods).flatMap(Stream::of).map(m -> ClassContext.methodInfo(classInfo, ClassContext.realMethod(m))).toList();
    }

    private static String methodNames(List<HelidonTestInfo.MethodInfo> methodInfos) {
        return methodInfos.stream().map(HelidonTestInfo.MethodInfo::element).map(Method::getName).collect(Collectors.joining(",", "[", "]"));
    }

    private static Method realMethod(ITestNGMethod tm) {
        return tm.getConstructorOrMethod().getMethod();
    }
}

