/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.Service;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.StaticContentSupport;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.jersey.JerseySupport;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import org.eclipse.microprofile.config.ConfigProvider;

public class ServerCdiExtension
implements Extension {
    private static final Logger LOGGER;
    private ServerConfiguration.Builder serverConfigBuilder = ServerConfiguration.builder().port(7001);
    private Routing.Builder routingBuilder = Routing.builder();
    private Map<String, Routing.Builder> namedRoutings = new HashMap<String, Routing.Builder>();
    private Supplier<? extends ExecutorService> jaxRsExecutorService;
    private String basePath;
    private Config config;
    private WebServer webserver;
    private volatile int port;
    private volatile String listenHost = "0.0.0.0";
    private volatile boolean started;

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.serverConfigBuilder.config(config.get("server"));
        this.config = config;
    }

    private void startServer(@Observes @Priority(value=4100) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        if (null == this.jaxRsExecutorService) {
            this.jaxRsExecutorService = ServerThreadPoolSupplier.builder().name("server").config(this.config.get("server.executor-service")).build();
        }
        ServerConfiguration serverConfig = this.serverConfigBuilder.build();
        this.registerJaxRsApplications(beanManager, serverConfig);
        this.registerWebServerServices(beanManager, serverConfig);
        this.registerDefaultRedirect();
        this.registerStaticContent();
        WebServer.Builder wsBuilder = WebServer.builder((Routing)this.routingBuilder.build());
        wsBuilder.config(serverConfig);
        this.namedRoutings.forEach((arg_0, arg_1) -> ((WebServer.Builder)wsBuilder).addNamedRouting(arg_0, arg_1));
        this.webserver = wsBuilder.build();
        try {
            this.webserver.start().toCompletableFuture().get();
            this.started = true;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to start webserver", (Throwable)e);
        }
        this.port = this.webserver.port();
        long initializationElapsedTime = ManagementFactory.getRuntimeMXBean().getUptime();
        if ("0.0.0.0".equals(this.listenHost)) {
            LOGGER.info(() -> "Server started on http://localhost:" + this.port + " (and all other host addresses) in " + initializationElapsedTime + " milliseconds (since JVM startup).");
        } else {
            LOGGER.info(() -> "Server started on http://" + this.listenHost + ":" + this.port + " in " + initializationElapsedTime + " milliseconds (since JVM startup).");
        }
        this.serverConfigBuilder = null;
        this.routingBuilder = null;
        this.namedRoutings = null;
    }

    private void registerJaxRsApplications(BeanManager beanManager, ServerConfiguration serverConfig) {
        JaxRsCdiExtension jaxRs = (JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class);
        jaxRs.applicationsToRun().forEach(it -> this.addApplication(serverConfig, jaxRs, (JaxRsApplication)it));
    }

    private void registerDefaultRedirect() {
        Optional.ofNullable(this.basePath).or(() -> this.config.get("server.base-path").asString().asOptional()).ifPresent(basePath -> this.routingBuilder.any("/", new Handler[]{(req, res) -> {
            res.status((Http.ResponseStatus)Http.Status.MOVED_PERMANENTLY_301);
            res.headers().put("Location", new String[]{basePath});
            res.send();
        }}));
    }

    private void registerStaticContent() {
        Config config = (Config)ConfigProvider.getConfig();
        config = config.get("server.static");
        config.get("classpath").ifExists(this::registerClasspathStaticContent);
        config.get("path").ifExists(this::registerPathStaticContent);
    }

    private void registerPathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentSupport.Builder pBuilder = StaticContentSupport.builder((Path)((Path)config.get("location").as(Path.class).get()));
        config.get("welcome").asString().ifPresent(arg_0 -> ((StaticContentSupport.Builder)pBuilder).welcomeFileName(arg_0));
        StaticContentSupport staticContent = pBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new Service[]{staticContent});
        } else {
            this.routingBuilder.register(new Service[]{staticContent});
        }
    }

    private void registerClasspathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentSupport.Builder cpBuilder = StaticContentSupport.builder((String)((String)config.get("location").asString().get()));
        cpBuilder.welcomeFileName((String)config.get("welcome").asString().orElse((Object)"index.html"));
        StaticContentSupport staticContent = cpBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new Service[]{staticContent});
        } else {
            this.routingBuilder.register(new Service[]{staticContent});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServer(@Observes @Priority(value=0) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (null == this.webserver) {
            return;
        }
        long beforeT = System.nanoTime();
        System.out.println("Stopping WebServer for " + event);
        try {
            this.webserver.shutdown().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.log(Level.SEVERE, "Failed to stop web server", e);
        }
        finally {
            long t = TimeUnit.MILLISECONDS.convert(System.nanoTime() - beforeT, TimeUnit.NANOSECONDS);
            LOGGER.info(() -> "Server stopped in " + t + " milliseconds.");
            System.out.println("Server stopped in " + t + " milliseconds.");
        }
    }

    private void addApplication(ServerConfiguration serverConfig, JaxRsCdiExtension jaxRs, JaxRsApplication applicationMeta) {
        LOGGER.info("Registering JAX-RS Application: " + applicationMeta.appName());
        Optional<String> contextRoot = jaxRs.findContextRoot(this.config, applicationMeta);
        Optional<String> namedRouting = jaxRs.findNamedRouting(this.config, applicationMeta);
        boolean routingNameRequired = jaxRs.isNamedRoutingRequired(this.config, applicationMeta);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Application " + applicationMeta.appName() + ", class: " + applicationMeta.appClassName() + ", contextRoot: " + contextRoot + ", namedRouting: " + namedRouting + ", routingNameRequired: " + routingNameRequired);
        }
        Routing.Builder routing = this.routingBuilder(namedRouting, routingNameRequired, serverConfig, applicationMeta.appName());
        JerseySupport jerseySupport = jaxRs.toJerseySupport(this.jaxRsExecutorService, applicationMeta);
        if (contextRoot.isPresent()) {
            String contextRootString = contextRoot.get();
            LOGGER.fine(() -> "JAX-RS application " + applicationMeta.appName() + " registered on '" + contextRootString + "'");
            routing.register(contextRootString, new Service[]{jerseySupport});
        } else {
            LOGGER.fine(() -> "JAX-RS application " + applicationMeta.appName() + " registered on '/'");
            routing.register(new Service[]{jerseySupport});
        }
    }

    public Routing.Builder routingBuilder(Optional<String> namedRouting, boolean routingNameRequired, ServerConfiguration serverConfig, String appName) {
        if (namedRouting.isPresent()) {
            String socket = namedRouting.get();
            if (null == serverConfig.socket(socket)) {
                if (routingNameRequired) {
                    throw new IllegalStateException("Application " + appName + " requires routing " + socket + " to exist, yet such a socket is not configured for web server");
                }
                LOGGER.info("Routing " + socket + " does not exist, using default routing for application " + appName);
                return this.serverRoutingBuilder();
            }
            return this.serverNamedRoutingBuilder(socket);
        }
        return this.serverRoutingBuilder();
    }

    private void registerWebServerServices(BeanManager beanManager, ServerConfiguration serverConfig) {
        List<Bean<?>> beans = ServerCdiExtension.prioritySort(beanManager.getBeans(Service.class, new Annotation[0]));
        CreationalContext context = beanManager.createCreationalContext(null);
        Iterator<Bean<?>> iterator = beans.iterator();
        while (iterator.hasNext()) {
            Bean<?> bean;
            Bean<?> objBean = bean = iterator.next();
            Class aClass = objBean.getBeanClass();
            Service service = (Service)objBean.create(context);
            this.registerWebServerService(aClass, service, serverConfig);
        }
    }

    private static List<Bean<?>> prioritySort(Set<Bean<?>> beans) {
        ArrayList prioritized = new ArrayList(beans);
        prioritized.sort((o1, o2) -> {
            int firstPriority = ServerCdiExtension.priority(o1.getBeanClass());
            int secondPriority = ServerCdiExtension.priority(o2.getBeanClass());
            return Integer.compare(firstPriority, secondPriority);
        });
        return prioritized;
    }

    private static int priority(Class<?> aClass) {
        Priority prio = aClass.getAnnotation(Priority.class);
        return null == prio ? 5000 : prio.value();
    }

    private void registerWebServerService(Class<?> serviceClass, Service service, ServerConfiguration serverConfig) {
        RoutingPath rp = serviceClass.getAnnotation(RoutingPath.class);
        RoutingName rn = serviceClass.getAnnotation(RoutingName.class);
        String path = null == rp ? null : rp.value();
        String routingName = null == rn ? null : rn.value();
        boolean routingNameRequired = null != rn && rn.required();
        path = (String)this.config.get(serviceClass.getName() + ".routing-path.path").asString().orElse((Object)path);
        routingName = (String)this.config.get(serviceClass.getName() + ".routing-name.name").asString().orElse((Object)routingName);
        routingNameRequired = (Boolean)this.config.get(serviceClass.getName() + ".routing-name.required").asBoolean().orElse((Object)routingNameRequired);
        Routing.Rules routing = this.findRouting(serviceClass.getName(), routingName, routingNameRequired, serverConfig);
        if (null == path || "/".equals(path)) {
            routing.register(new Service[]{service});
        } else {
            routing.register(path, new Service[]{service});
        }
    }

    private Routing.Rules findRouting(String className, String routingName, boolean routingNameRequired, ServerConfiguration serverConfig) {
        if (null == routingName || "@default".equals(routingName)) {
            return this.serverRoutingBuilder();
        }
        SocketConfiguration socket = serverConfig.socket(routingName);
        if (null == socket) {
            if (routingNameRequired) {
                throw new IllegalStateException(className + " requires routing " + routingName + ", yet such a named socket is not configured for web server");
            }
            LOGGER.fine(() -> className + " is configured with named routing " + routingName + ". Such a routing is not configured, this service/application will run on default socket.");
            return this.serverRoutingBuilder();
        }
        return this.serverNamedRoutingBuilder(routingName);
    }

    public ServerConfiguration.Builder serverConfigBuilder() {
        return this.serverConfigBuilder;
    }

    public Routing.Builder serverRoutingBuilder() {
        return this.routingBuilder;
    }

    public Routing.Builder serverNamedRoutingBuilder(String name) {
        return this.namedRoutings.computeIfAbsent(name, routeName -> Routing.builder());
    }

    public void defaultExecutorService(Supplier<? extends ExecutorService> defaultExecutorService) {
        this.jaxRsExecutorService = defaultExecutorService;
    }

    public String host() {
        return this.listenHost;
    }

    public int port() {
        return this.port;
    }

    public boolean started() {
        return this.started;
    }

    public void basePath(String basePath) {
        this.basePath = basePath;
    }

    void listenHost(String listenHost) {
        this.listenHost = listenHost;
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.MP, (String[])new String[]{"Server"});
        LOGGER = Logger.getLogger(ServerCdiExtension.class.getName());
    }
}

