/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.scheduling;

import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.scheduling.FixedRate;
import io.helidon.microprofile.scheduling.Scheduled;
import io.helidon.scheduling.Invocation;
import io.helidon.scheduling.Scheduling;
import io.helidon.scheduling.Task;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.WithAnnotations;

public class SchedulingCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(SchedulingCdiExtension.class.getName());
    private static final Pattern CRON_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(?<key>[^\\}]+)\\}");
    private final Queue<AnnotatedMethod<?>> methods = new LinkedList();
    private final Map<AnnotatedMethod<?>, Bean<?>> beans = new HashMap();
    private final Queue<ScheduledExecutorService> executors = new LinkedList<ScheduledExecutorService>();
    private Config config;
    private Config schedulingConfig;

    void registerMethods(@Observes @WithAnnotations(value={Scheduled.class, FixedRate.class}) ProcessAnnotatedType<?> pat) {
        pat.getAnnotatedType().getMethods().stream().filter(am -> am.isAnnotationPresent(Scheduled.class) || am.isAnnotationPresent(FixedRate.class)).forEach(this.methods::add);
    }

    void onProcessBean(@Observes ProcessManagedBean<?> event) {
        Bean bean = event.getBean();
        Class beanClass = bean.getBeanClass();
        for (AnnotatedMethod annotatedMethod : this.methods) {
            if (beanClass != annotatedMethod.getDeclaringType().getJavaClass()) continue;
            this.beans.put(annotatedMethod, bean);
        }
    }

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.config = config;
        this.schedulingConfig = config.get("schedule");
    }

    void invoke(@Observes @Priority(value=8000) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        ScheduledThreadPoolSupplier scheduledThreadPoolSupplier = ScheduledThreadPoolSupplier.builder().threadNamePrefix((String)this.schedulingConfig.get("thread-name-prefix").asString().orElse((Object)"scheduled-")).config(this.schedulingConfig).build();
        for (AnnotatedMethod annotatedMethod : this.methods) {
            Annotation annotation;
            Class aClass = annotatedMethod.getDeclaringType().getJavaClass();
            Bean<?> bean = this.beans.get(annotatedMethod);
            Object beanInstance = SchedulingCdiExtension.lookup(bean, beanManager);
            ScheduledExecutorService executorService = scheduledThreadPoolSupplier.get();
            this.executors.add(executorService);
            Method method = annotatedMethod.getJavaMember();
            if (!method.trySetAccessible()) {
                throw new DeploymentException(String.format("Scheduled method %s#%s is not accessible!", method.getDeclaringClass().getName(), method.getName()));
            }
            if (annotatedMethod.isAnnotationPresent(FixedRate.class) && annotatedMethod.isAnnotationPresent(Scheduled.class)) {
                throw new DeploymentException(String.format("Scheduled method %s#%s can have only one scheduling annotation.", method.getDeclaringClass().getName(), method.getName()));
            }
            Config methodConfig = this.config.get(aClass.getName() + "." + method.getName() + ".schedule");
            if (annotatedMethod.isAnnotationPresent(FixedRate.class)) {
                annotation = (FixedRate)annotatedMethod.getAnnotation(FixedRate.class);
                long initialDelay = (Long)methodConfig.get("initial-delay").asLong().orElseGet(((FixedRate)annotation)::initialDelay);
                long delay = (Long)methodConfig.get("delay").asLong().orElseGet(((FixedRate)annotation)::value);
                TimeUnit timeUnit = methodConfig.get("time-unit").asString().map(TimeUnit::valueOf).orElseGet(((FixedRate)annotation)::timeUnit);
                Task task = Scheduling.fixedRateBuilder().executor(executorService).initialDelay(initialDelay).delay(delay).timeUnit(timeUnit).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv)).build();
                LOGGER.log(Level.FINE, () -> String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description()));
                continue;
            }
            if (!annotatedMethod.isAnnotationPresent(Scheduled.class)) continue;
            annotation = (Scheduled)annotatedMethod.getAnnotation(Scheduled.class);
            String cron = (String)methodConfig.get("cron").asString().orElseGet(() -> this.lambda$invoke$3((Scheduled)annotation));
            boolean concurrent = (Boolean)methodConfig.get("concurrent").asBoolean().orElseGet(((Scheduled)annotation)::concurrentExecution);
            Task task = Scheduling.cronBuilder().executor(executorService).concurrentExecution(concurrent).expression(cron).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv)).build();
            LOGGER.log(Level.FINE, () -> String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description()));
        }
    }

    void terminate(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.executors.forEach(ExecutorService::shutdownNow);
    }

    static <T> T lookup(Bean<?> bean, BeanManager beanManager) {
        Context context = beanManager.getContext(bean.getScope());
        Object instance = context.get(bean);
        if (instance == null) {
            CreationalContext creationalContext = beanManager.createCreationalContext(bean);
            instance = beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
        }
        if (instance == null) {
            throw new DeploymentException("Instance of bean " + bean.getName() + " not found");
        }
        return (T)instance;
    }

    static void invokeWithOptionalParam(Object instance, Method method, Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> invClazz = invocation.getClass();
        if (parameterTypes.length > 1 || parameterTypes.length > 0 && !parameterTypes[0].isAssignableFrom(invClazz)) {
            throw new DeploymentException(String.format("Unsupported param types for scheduled method %s, none or %s is supported.", method.getName(), invClazz.getName()));
        }
        if (parameterTypes.length == 0) {
            method.invoke(instance, new Object[0]);
        } else {
            method.invoke(instance, invocation);
        }
    }

    static String resolvePlaceholders(String src, Config config) {
        Matcher m = CRON_PLACEHOLDER_PATTERN.matcher(src);
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (m.find()) {
            String key = m.group("key");
            String value = (String)config.get(key).asString().orElseThrow(() -> new IllegalArgumentException(String.format("Scheduling placeholder %s could not be resolved.", key)));
            result.append(src, index, m.start()).append(value);
            index = m.end();
        }
        if (index < src.length()) {
            result.append(src, index, src.length());
        }
        return result.toString();
    }

    private /* synthetic */ String lambda$invoke$3(Scheduled annotation) {
        return SchedulingCdiExtension.resolvePlaceholders(annotation.value(), this.config);
    }
}

