/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.config.Config;
import io.helidon.microprofile.openapi.MPOpenAPIBuilder;
import io.helidon.microprofile.openapi.MpOpenApiFeature;
import io.helidon.microprofile.servicecommon.HelidonRestCdiExtension;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenApiCdiExtension
extends HelidonRestCdiExtension<MpOpenApiFeature> {
    private static final System.Logger LOGGER = System.getLogger(OpenApiCdiExtension.class.getName());
    static final String INDEX_PATH = "META-INF/jandex.idx";
    private final Set<Class<?>> annotatedTypes = new HashSet();

    private static Function<Config, MpOpenApiFeature> featureFactory(String ... indexPaths) {
        return helidonConfig -> {
            org.eclipse.microprofile.config.Config mpConfig = ConfigProvider.getConfig();
            MPOpenAPIBuilder builder = MpOpenApiFeature.builder().config((Config)helidonConfig).indexPaths(indexPaths).config(mpConfig);
            return builder.build();
        };
    }

    public OpenApiCdiExtension() throws IOException {
        this(INDEX_PATH);
    }

    OpenApiCdiExtension(String ... indexPaths) throws IOException {
        super(LOGGER, OpenApiCdiExtension.featureFactory(indexPaths), "openapi");
    }

    protected void processManagedBean(ProcessManagedBean<?> processManagedBean) {
    }

    void buildModel(@Observes @Priority(value=4110) @Initialized(value=ApplicationScoped.class) Object event) {
        ((MpOpenApiFeature)this.serviceSupport()).prepareModel();
    }

    MpOpenApiFeature feature() {
        return (MpOpenApiFeature)this.serviceSupport();
    }

    Set<Class<?>> annotatedTypes() {
        return this.annotatedTypes;
    }

    private <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        Class c = event.getAnnotatedType().getJavaClass();
        this.annotatedTypes.add(c);
    }
}

