/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.openapi.ExpandedTypeDescription;
import io.helidon.microprofile.openapi.HelidonAnnotationScannerExtension;
import io.helidon.microprofile.openapi.MPOpenAPIBuilder;
import io.helidon.microprofile.openapi.OpenApiParser;
import io.helidon.microprofile.openapi.ParserHelper;
import io.helidon.microprofile.openapi.Serializer;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.openapi.OpenApiFeature;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import jakarta.enterprise.inject.spi.CDI;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

public class MpOpenApiFeature
extends OpenApiFeature {
    static final LazyValue<ParserHelper> PARSER_HELPER = LazyValue.create(ParserHelper::create);
    private static final System.Logger LOGGER = System.getLogger(MpOpenApiFeature.class.getName());
    private final Supplier<List<FilteredIndexView>> filteredIndexViewsSupplier;
    private final Lock modelAccess = new ReentrantLock(true);
    private final OpenApiConfig openApiConfig;
    private final io.helidon.openapi.OpenApiStaticFile openApiStaticFile;
    private final MPOpenAPIBuilder builder;
    private OpenAPI model;
    private final Map<Class<?>, ExpandedTypeDescription> implsToTypes;

    public static MPOpenAPIBuilder builder() {
        return new MPOpenAPIBuilder();
    }

    static List<JaxRsApplication> jaxRsApplicationsToRun() {
        JaxRsCdiExtension ext = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
        return ext.applicationsToRun();
    }

    protected MpOpenApiFeature(MPOpenAPIBuilder builder) {
        super(LOGGER, (OpenApiFeature.Builder)builder);
        this.builder = builder;
        this.implsToTypes = this.buildImplsToTypes();
        this.openApiConfig = builder.openApiConfig();
        this.openApiStaticFile = builder.staticFile();
        this.filteredIndexViewsSupplier = builder::buildPerAppFilteredIndexViews;
    }

    protected String openApiContent(OpenApiFeature.OpenAPIMediaType openApiMediaType) {
        return this.openApiContent(openApiMediaType, this.model());
    }

    protected void prepareModel() {
        this.model();
    }

    static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    IndexView indexView() {
        return this.builder.indexView();
    }

    Map<Class<?>, ExpandedTypeDescription> buildImplsToTypes() {
        return Collections.unmodifiableMap(((ParserHelper)PARSER_HELPER.get()).types().values().stream().collect(Collectors.toMap(ExpandedTypeDescription::impl, Function.identity())));
    }

    private String openApiContent(OpenApiFeature.OpenAPIMediaType openAPIMediaType, OpenAPI model) {
        StringWriter sw = new StringWriter();
        Serializer.serialize(((ParserHelper)PARSER_HELPER.get()).types(), this.implsToTypes, model, openAPIMediaType, sw);
        return sw.toString();
    }

    private OpenAPI prepareModel(OpenApiConfig config, OpenApiStaticFile staticFile, List<? extends IndexView> filteredIndexViews) {
        try {
            OpenApiDocument.INSTANCE.reset();
            OpenApiDocument.INSTANCE.config(config);
            OpenApiDocument.INSTANCE.modelFromReader(OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)MpOpenApiFeature.contextClassLoader()));
            if (staticFile != null) {
                OpenApiDocument.INSTANCE.modelFromStaticFile(OpenApiParser.parse(((ParserHelper)PARSER_HELPER.get()).types(), staticFile.getContent()));
            }
            if (this.isAnnotationProcessingEnabled(config)) {
                this.expandModelUsingAnnotations(config, filteredIndexViews);
            } else {
                LOGGER.log(System.Logger.Level.TRACE, "OpenAPI Annotation processing is disabled");
            }
            OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)MpOpenApiFeature.contextClassLoader()));
            OpenApiDocument.INSTANCE.initialize();
            OpenAPIImpl instance = (OpenAPIImpl)OpenAPIImpl.class.cast(OpenApiDocument.INSTANCE.get());
            return MergeUtil.merge((OpenAPI)new OpenAPIImpl(), (OpenAPI)instance).openapi(instance.getOpenapi());
        }
        catch (IOException ex) {
            throw new RuntimeException("Error initializing OpenAPI information", ex);
        }
    }

    private static Format toFormat(OpenApiFeature.OpenAPIMediaType openAPIMediaType) {
        return openAPIMediaType.equals((Object)OpenApiFeature.OpenAPIMediaType.YAML) ? Format.YAML : Format.JSON;
    }

    private boolean isAnnotationProcessingEnabled(OpenApiConfig config) {
        return !config.scanDisable();
    }

    private void expandModelUsingAnnotations(OpenApiConfig config, List<? extends IndexView> filteredIndexViews) {
        if (filteredIndexViews.isEmpty() || config.scanDisable()) {
            return;
        }
        AtomicReference<OpenAPIImpl> aggregateModelRef = new AtomicReference<OpenAPIImpl>(new OpenAPIImpl());
        filteredIndexViews.forEach(filteredIndexView -> {
            OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, filteredIndexView, List.of(new HelidonAnnotationScannerExtension()));
            OpenAPI modelForApp = scanner.scan(new String[0]);
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("Intermediate model from filtered index view %s:%n%s", filteredIndexView.getKnownClasses(), this.openApiContent(OpenApiFeature.OpenAPIMediaType.YAML, modelForApp)));
            }
            aggregateModelRef.set((OpenAPIImpl)MergeUtil.merge((OpenAPI)((OpenAPI)aggregateModelRef.get()), (OpenAPI)modelForApp).openapi(modelForApp.getOpenapi()));
        });
        OpenApiDocument.INSTANCE.modelFromAnnotations((OpenAPI)aggregateModelRef.get());
    }

    private OpenAPI model() {
        return this.access(() -> {
            if (this.model == null) {
                this.model = this.prepareModel(this.openApiConfig, MpOpenApiFeature.toSmallRye(this.openApiStaticFile), this.filteredIndexViewsSupplier.get());
            }
            return this.model;
        });
    }

    private static OpenApiStaticFile toSmallRye(io.helidon.openapi.OpenApiStaticFile staticFile) {
        return staticFile == null ? null : new OpenApiStaticFile((InputStream)new BufferedInputStream(new ByteArrayInputStream(staticFile.content().getBytes(Charset.defaultCharset()))), MpOpenApiFeature.toFormat(staticFile.openApiMediaType()));
    }

    private <T> T access(Supplier<T> operation) {
        this.modelAccess.lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.modelAccess.unlock();
        }
    }
}

