/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.openapi.MPOpenAPIBuilder;
import io.helidon.microprofile.openapi.MPOpenAPISupport;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.RoutingBuilders;
import io.helidon.nima.webserver.http.HttpRules;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class OpenApiCdiExtension
implements Extension {
    private static final String INDEX_PATH = "META-INF/jandex.idx";
    private static final System.Logger LOGGER = System.getLogger(OpenApiCdiExtension.class.getName());
    private final String[] indexPaths;
    private final int indexURLCount;
    private final Set<Class<?>> annotatedTypes = new HashSet();
    private org.eclipse.microprofile.config.Config mpConfig;
    private Config config;
    private MPOpenAPISupport openApiSupport;

    public OpenApiCdiExtension() throws IOException {
        this(INDEX_PATH);
    }

    OpenApiCdiExtension(String ... indexPaths) throws IOException {
        this.indexPaths = indexPaths;
        List<URL> indexURLs = this.findIndexFiles(indexPaths);
        this.indexURLCount = indexURLs.size();
        if (indexURLs.isEmpty()) {
            LOGGER.log(System.Logger.Level.INFO, () -> String.format("OpenAPI support could not locate the Jandex index file %s so will build an in-memory index.%nThis slows your app start-up and, depending on CDI configuration, might omit some type information needed for a complete OpenAPI document.%nConsider using the Jandex maven plug-in during your build to create the index and add it to your app.", INDEX_PATH));
        }
    }

    private void configure(@Observes @RuntimeStart Config config) {
        this.mpConfig = (org.eclipse.microprofile.config.Config)config;
        this.config = config;
    }

    void registerOpenApi(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object event) {
        Config openapiNode = this.config.get("openapi");
        this.openApiSupport = ((MPOpenAPIBuilder)new MPOpenAPIBuilder().config(this.mpConfig).singleIndexViewSupplier(this::indexView).config(openapiNode)).build();
        this.openApiSupport.configureEndpoint((HttpRules)RoutingBuilders.create((Config)openapiNode).routingBuilder());
    }

    void buildModel(@Observes @Priority(value=4110) @Initialized(value=ApplicationScoped.class) Object event) {
        this.openApiSupport.prepareModel();
    }

    private <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        if (this.indexURLCount == 0) {
            Class c = event.getAnnotatedType().getJavaClass();
            this.annotatedTypes.add(c);
        }
    }

    public IndexView indexView() {
        try {
            return this.indexURLCount > 0 ? this.existingIndexFileReader() : this.indexFromHarvestedClasses();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexView existingIndexFileReader() throws IOException {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (URL indexURL : this.findIndexFiles(this.indexPaths)) {
            try {
                InputStream indexIS = indexURL.openStream();
                try {
                    LOGGER.log(System.Logger.Level.DEBUG, "Adding Jandex index at {0}", indexURL.toString());
                    indices.add(new IndexReader(indexIS).read());
                }
                finally {
                    if (indexIS == null) continue;
                    indexIS.close();
                }
            }
            catch (Exception ex) {
                throw new IOException("Attempted to read from previously-located index file " + String.valueOf(indexURL) + " but the index cannot be read", ex);
            }
        }
        return indices.size() == 1 ? (IndexView)indices.get(0) : CompositeIndex.create(indices);
    }

    private IndexView indexFromHarvestedClasses() throws IOException {
        Indexer indexer = new Indexer();
        this.annotatedTypes.forEach(c -> this.addClassToIndexer(indexer, (Class<?>)c));
        MPOpenAPIBuilder.jaxRsApplicationsToRun().stream().map(JaxRsApplication::applicationClass).filter(Optional::isPresent).forEach(appClassOpt -> this.addClassToIndexer(indexer, (Class)appClassOpt.get()));
        LOGGER.log(System.Logger.Level.DEBUG, "Using internal Jandex index created from CDI bean discovery");
        Index result = indexer.complete();
        OpenApiCdiExtension.dumpIndex(System.Logger.Level.TRACE, result);
        return result;
    }

    private void addClassToIndexer(Indexer indexer, Class<?> c) {
        try (InputStream is = OpenApiCdiExtension.contextClassLoader().getResourceAsStream(OpenApiCdiExtension.resourceNameForClass(c));){
            indexer.index(is);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Cannot load bytecode from class %s at %s for annotation processing", c.getName(), OpenApiCdiExtension.resourceNameForClass(c)), ex);
        }
    }

    private List<URL> findIndexFiles(String ... indexPaths) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String indexPath : indexPaths) {
            Enumeration<URL> urls = OpenApiCdiExtension.contextClassLoader().getResources(indexPath);
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpIndex(System.Logger.Level level, Index index) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Dump of internal Jandex index:");
            PrintStream oldStdout = System.out;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream newPS = new PrintStream((OutputStream)baos, true, Charset.defaultCharset());){
                System.setOut(newPS);
                index.printAnnotations();
                index.printSubclasses();
                LOGGER.log(level, baos.toString(Charset.defaultCharset()));
            }
            finally {
                System.setOut(oldStdout);
            }
        }
    }

    private static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String resourceNameForClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".class";
    }
}

