/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.microprofile.openapi.MPOpenAPISupport;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.openapi.OpenAPISupport;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.IndexView;

public final class MPOpenAPIBuilder
extends OpenAPISupport.Builder<MPOpenAPIBuilder> {
    private static final Logger LOGGER = Logger.getLogger(MPOpenAPIBuilder.class.getName());
    private Optional<OpenApiConfig> openAPIConfig;
    private Supplier<? extends IndexView> singleIndexViewSupplier = null;
    private Config mpConfig;

    protected MPOpenAPIBuilder() {
        super(MPOpenAPIBuilder.class);
    }

    public OpenApiConfig openAPIConfig() {
        return this.openAPIConfig.get();
    }

    public MPOpenAPISupport build() {
        MPOpenAPISupport result = new MPOpenAPISupport(this);
        this.validate();
        return result;
    }

    static List<JaxRsApplication> jaxRsApplicationsToRun() {
        JaxRsCdiExtension ext = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
        List jaxRsAppsToRun = ext.applicationsToRun();
        return jaxRsAppsToRun.stream().filter(MPOpenAPIBuilder::isNonSynthetic).collect(Collectors.toList());
    }

    private List<FilteredIndexView> buildPerAppFilteredIndexViews() {
        List appClassesToScan = MPOpenAPIBuilder.jaxRsApplicationsToRun().stream().filter(jaxRsApplication -> jaxRsApplication.applicationClass().isPresent()).sorted(Comparator.comparing(jaxRsApplication -> ((Class)jaxRsApplication.applicationClass().get()).getName())).map(this::classesToScanForJaxRsApp).collect(Collectors.toList());
        if (appClassesToScan.size() <= 1) {
            return List.of(new FilteredIndexView(this.singleIndexViewSupplier.get(), this.openAPIConfig.get()));
        }
        return appClassesToScan.stream().map(this::appRelatedClassesToFilteredIndexView).collect(Collectors.toList());
    }

    private static boolean isNonSynthetic(JaxRsApplication jaxRsApp) {
        return !jaxRsApp.synthetic();
    }

    private Set<Class<?>> classesToScanForJaxRsApp(JaxRsApplication jaxRsApplication) {
        if (jaxRsApplication.synthetic()) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        Class appClass = (Class)jaxRsApplication.applicationClass().get();
        result.add(appClass);
        Application app = jaxRsApplication.resourceConfig().getApplication();
        if (app != null) {
            result.addAll(this.classesToScanForAppInstance(app));
        } else {
            LOGGER.log(Level.WARNING, String.format("Expected application instance not created yet for %s", appClass.getName()));
        }
        return result;
    }

    private List<Class<?>> classesToScanForAppInstance(Application app) {
        ArrayList result = new ArrayList();
        result.addAll(app.getClasses());
        app.getSingletons().stream().map(Object::getClass).forEach(result::add);
        return result;
    }

    private FilteredIndexView appRelatedClassesToFilteredIndexView(Set<Class<?>> appRelatedClassesToScan) {
        Pattern appRelatedClassesPattern = Pattern.compile(appRelatedClassesToScan.stream().map(Class::getName).map(Pattern::quote).map(name -> "^" + name + "$").collect(Collectors.joining("|", "(", ")")));
        FilteredIndexView result = new FilteredIndexView(this.singleIndexViewSupplier.get(), (OpenApiConfig)new FilteringOpenApiConfigImpl(this.mpConfig, appRelatedClassesPattern));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("FilteredIndexView for %n  application classes %s%n  will use pattern: %s%n  with known classes %s", appRelatedClassesToScan, appRelatedClassesPattern, result.getKnownClasses()));
        }
        return result;
    }

    private MPOpenAPIBuilder openAPIConfig(OpenApiConfig config) {
        this.openAPIConfig = Optional.of(config);
        return this;
    }

    MPOpenAPIBuilder config(Config mpConfig) {
        this.mpConfig = mpConfig;
        this.openAPIConfig((OpenApiConfig)new OpenApiConfigImpl(mpConfig));
        return this;
    }

    MPOpenAPIBuilder singleIndexViewSupplier(Supplier<? extends IndexView> singleIndexViewSupplier) {
        this.singleIndexViewSupplier = singleIndexViewSupplier;
        return this;
    }

    protected Supplier<List<? extends IndexView>> indexViewsSupplier() {
        return this::buildPerAppFilteredIndexViews;
    }

    public void validate() throws IllegalStateException {
        super.validate();
        if (!this.openAPIConfig.isPresent()) {
            throw new IllegalStateException("OpenApiConfig has not been set in MPBuilder");
        }
        Objects.requireNonNull(this.singleIndexViewSupplier, "singleIndexViewSupplier must be set but was not");
    }

    private static class FilteringOpenApiConfigImpl
    extends OpenApiConfigImpl {
        private final Pattern appRelatedClassNamesToScan;

        FilteringOpenApiConfigImpl(Config config, Pattern appRelatedClassNamesToScan) {
            super(config);
            this.appRelatedClassNamesToScan = appRelatedClassNamesToScan;
        }

        public Pattern scanClasses() {
            return this.appRelatedClassNamesToScan;
        }
    }
}

