/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class IndexBuilder
implements Extension {
    private static final String INDEX_PATH = "/META-INF/jandex.idx";
    private static final Logger LOGGER = Logger.getLogger(IndexBuilder.class.getName());
    private final boolean isIndexPresentOnClasspath;
    private final Set<Class<?>> annotatedTypes = new HashSet();

    public IndexBuilder() throws IOException {
        this.isIndexPresentOnClasspath = this.checkForIndexFile();
        if (this.isIndexPresentOnClasspath) {
            LOGGER.log(Level.FINE, () -> String.format("Index file %s was located and will be used", INDEX_PATH));
        } else {
            LOGGER.log(Level.INFO, () -> String.format("OpenAPI support could not locate the Jandex index file %s so will build an in-memory index.%nThis slows your app start-up and, depending on CDI configuration, might omit some type information needed for a complete OpenAPI document.%nConsider using the Jandex maven plug-in during your build to create the index and add it to your app.", INDEX_PATH));
        }
    }

    private <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> type) {
        if (this.isIndexPresentOnClasspath) {
            return;
        }
        Class c = type.getAnnotatedType().getJavaClass();
        this.annotatedTypes.add(c);
    }

    public IndexView indexView() throws IOException {
        return this.isIndexPresentOnClasspath ? this.existingIndexFileReader() : this.indexFromHarvestedClasses();
    }

    private IndexView existingIndexFileReader() throws IOException {
        Index index;
        block8: {
            InputStream jandexIS = this.getClass().getResourceAsStream(INDEX_PATH);
            try {
                LOGGER.log(Level.FINE, "Using Jandex index at {0}", INDEX_PATH);
                index = new IndexReader(jandexIS).read();
                if (jandexIS == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jandexIS != null) {
                        try {
                            jandexIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IOException("Attempted to read from previously-located index file /META-INF/jandex.idx but the file cannot be found", ex);
                }
            }
            jandexIS.close();
        }
        return index;
    }

    private IndexView indexFromHarvestedClasses() throws IOException {
        Indexer indexer = new Indexer();
        for (Class<?> c : this.annotatedTypes) {
            try {
                InputStream is = IndexBuilder.contextClassLoader().getResourceAsStream(IndexBuilder.resourceNameForClass(c));
                try {
                    indexer.index(is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new IOException("Cannot load bytecode from class " + c.getName() + " at " + IndexBuilder.resourceNameForClass(c) + " for annotation processing", ex);
            }
        }
        LOGGER.log(Level.FINE, "Using internal Jandex index created from CDI bean discovery");
        Index result = indexer.complete();
        IndexBuilder.dumpIndex(Level.FINER, result);
        return result;
    }

    private boolean checkForIndexFile() throws IOException {
        try (InputStream jandexIS = this.getClass().getResourceAsStream(INDEX_PATH);){
            boolean bl = jandexIS != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpIndex(Level level, Index index) throws UnsupportedEncodingException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Dump of internal Jandex index:");
            PrintStream oldStdout = System.out;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream newPS = new PrintStream((OutputStream)baos, true, Charset.defaultCharset().name());){
                System.setOut(newPS);
                index.printAnnotations();
                index.printSubclasses();
                LOGGER.log(level, baos.toString(Charset.defaultCharset().name()));
            }
            finally {
                System.setOut(oldStdout);
            }
        }
    }

    private static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String resourceNameForClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".class";
    }
}

