/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.AbstractDescriptiveElement;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class SchemaEnum
extends AbstractDescriptiveElement
implements ElementGenerator {
    private String name;
    private List<String> values;

    private SchemaEnum(Builder builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.description(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public List<String> values() {
        return this.values;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public String getSchemaAsString() {
        StringBuilder sb = new StringBuilder(this.getSchemaElementDescription(null)).append("enum").append(" ").append(this.name()).append(" ").append("{").append('\n');
        this.values.forEach(v -> sb.append(" ").append((String)v).append('\n'));
        return sb.append("}").append('\n').toString();
    }

    public String toString() {
        return "Enum{name='" + this.name + "', values=" + this.values + ", description='" + this.description() + "'}";
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, SchemaEnum> {
        private String name;
        private List<String> values = new ArrayList<String>();
        private String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addValue(String value) {
            this.values.add(value);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaEnum build() {
            Objects.requireNonNull(this.name, "Name must be specified");
            return new SchemaEnum(this);
        }
    }
}

