/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;

class JsonUtils {
    private static final Jsonb JSONB = JsonbBuilder.newBuilder().withConfig(new JsonbConfig().setProperty("jsonb.zero-time-defaulting", (Object)true).withNullValues(Boolean.valueOf(true)).withAdapters(new JsonbAdapter[0])).build();

    private JsonUtils() {
    }

    public static Map<String, Object> convertJSONtoMap(String json) {
        if (json == null || json.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return (Map)JSONB.fromJson(json, LinkedHashMap.class);
    }

    public static String convertMapToJson(Map map) {
        return JSONB.toJson((Object)map);
    }

    public static Object convertFromJson(String json, Class<?> clazz) {
        return JSONB.fromJson(json, clazz);
    }

    public static Map convertObjectToMap(Object value) {
        return JsonUtils.convertJSONtoMap(JSONB.toJson(value));
    }

    public static String convertJsonToGraphQLSDL(Object value) {
        return JsonUtils.convertJsonToGraphQLSDL(value, false);
    }

    public static String convertJsonToGraphQLSDL(Object value, boolean isKey) {
        StringBuffer sb = new StringBuffer();
        if (value instanceof Map) {
            sb.append(JsonUtils.convertJsonMapToGraphQLSDL((Map)value));
        } else if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof String) {
            if (isKey) {
                sb.append(value.toString());
            } else {
                sb.append("\"").append(value.toString().replaceAll("\"", "\\\\\"")).append("\"");
            }
        } else if (value instanceof Collection) {
            sb.append("[");
            sb.append((Object)((Collection)value).stream().map(JsonUtils::convertJsonToGraphQLSDL).collect(Collectors.joining(", "))).append("]");
        } else {
            sb.append(value.toString());
        }
        return sb.toString();
    }

    private static String convertJsonMapToGraphQLSDL(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer("{");
        int count = 1;
        int mapSize = map.entrySet().size();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (count == 1) {
                sb.append(" ");
            }
            sb.append(JsonUtils.convertJsonToGraphQLSDL(entry.getKey(), true)).append(':').append(" ");
            sb.append(JsonUtils.convertJsonToGraphQLSDL(entry.getValue()));
            if (count++ == mapSize) continue;
            sb.append(", ");
        }
        return sb.append("}").toString();
    }
}

