/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.AbstractDescriptiveElement;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import io.helidon.microprofile.graphql.server.SchemaFieldDefinition;
import io.helidon.microprofile.graphql.server.SchemaInputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class SchemaType
extends AbstractDescriptiveElement
implements ElementGenerator {
    private String name;
    private String valueClassName;
    private boolean isInterface;
    private String implementingInterface;
    private List<SchemaFieldDefinition> listSchemaFieldDefinitions;

    protected SchemaType(String name, String valueClassName) {
        this.name = name;
        this.valueClassName = valueClassName;
        this.listSchemaFieldDefinitions = new ArrayList<SchemaFieldDefinition>();
    }

    private SchemaType(Builder builder) {
        this.name = builder.name;
        this.valueClassName = builder.valueClassName;
        this.isInterface = builder.isInterface;
        this.implementingInterface = builder.implementingInterface;
        this.listSchemaFieldDefinitions = builder.listSchemaFieldDefinitions;
        this.description(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getSchemaAsString() {
        if (this.listSchemaFieldDefinitions.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.getSchemaElementDescription(null)).append(this.getGraphQLName()).append(" ").append(this.name());
        if (this.implementingInterface != null) {
            sb.append(" implements ").append(this.implementingInterface);
        }
        sb.append(" ").append("{").append('\n');
        this.listSchemaFieldDefinitions.forEach(fd -> sb.append(fd.getSchemaAsString()).append('\n'));
        sb.append("}").append('\n');
        return sb.toString();
    }

    public SchemaInputType createInputType(String sSuffix) {
        SchemaInputType inputType = new SchemaInputType(this.name() + sSuffix, this.valueClassName());
        this.fieldDefinitions().forEach(fd -> {
            fd.arguments().clear();
            inputType.addFieldDefinition((SchemaFieldDefinition)fd);
        });
        return inputType;
    }

    public void isInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String valueClassName() {
        return this.valueClassName;
    }

    public List<SchemaFieldDefinition> fieldDefinitions() {
        return this.listSchemaFieldDefinitions;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public String implementingInterface() {
        return this.implementingInterface;
    }

    public void implementingInterface(String implementingInterface) {
        this.implementingInterface = implementingInterface;
    }

    public void addFieldDefinition(SchemaFieldDefinition schemaFieldDefinition) {
        this.listSchemaFieldDefinitions.add(schemaFieldDefinition);
    }

    public boolean hasFieldDefinitions() {
        return this.listSchemaFieldDefinitions != null && this.listSchemaFieldDefinitions.size() > 0;
    }

    public SchemaFieldDefinition getFieldDefinitionByName(String fdName) {
        for (SchemaFieldDefinition fieldDefinition : this.listSchemaFieldDefinitions) {
            if (!fieldDefinition.name().equals(fdName)) continue;
            return fieldDefinition;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaType schemaType = (SchemaType)o;
        return this.isInterface == schemaType.isInterface && Objects.equals(this.name, schemaType.name) && Objects.equals(this.valueClassName, schemaType.valueClassName) && Objects.equals(this.implementingInterface, schemaType.implementingInterface) && Objects.equals(this.listSchemaFieldDefinitions, schemaType.listSchemaFieldDefinitions) && Objects.equals(this.description(), schemaType.description());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.valueClassName, this.isInterface, this.implementingInterface, this.description(), this.listSchemaFieldDefinitions);
    }

    public String toString() {
        return "Type" + this.toStringInternal();
    }

    protected String toStringInternal() {
        return "{name='" + this.name + "', valueClassName='" + this.valueClassName + "', isInterface='" + this.isInterface + "', description='" + this.description() + "', implementingInterface='" + this.implementingInterface + "', listFieldDefinitions=" + this.listSchemaFieldDefinitions + "}";
    }

    protected String getGraphQLName() {
        return this.isInterface() ? "interface" : "type";
    }

    public static class Builder
    implements io.helidon.common.Builder<SchemaType> {
        private String name;
        private String valueClassName;
        private String description;
        private boolean isInterface;
        private String implementingInterface;
        private List<SchemaFieldDefinition> listSchemaFieldDefinitions = new ArrayList<SchemaFieldDefinition>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder valueClassName(String valueClassName) {
            this.valueClassName = valueClassName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder isInterface(boolean isInterface) {
            this.isInterface = isInterface;
            return this;
        }

        public Builder implementingInterface(String implementingInterface) {
            this.implementingInterface = implementingInterface;
            return this;
        }

        public Builder addFieldDefinition(SchemaFieldDefinition fieldDefinition) {
            this.listSchemaFieldDefinitions.add(fieldDefinition);
            return this;
        }

        public SchemaType build() {
            Objects.requireNonNull(this.name, "Name must be specified");
            return new SchemaType(this);
        }
    }
}

