/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.config.Config;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.vault.Engine;
import io.helidon.integrations.vault.secrets.database.DbSecrets;
import io.helidon.integrations.vault.secrets.database.DbSecretsImpl;
import io.helidon.integrations.vault.secrets.database.DbSecretsRx;
import io.helidon.integrations.vault.secrets.database.DbSecretsRxImpl;
import io.helidon.integrations.vault.spi.InjectionProvider;
import io.helidon.integrations.vault.spi.SecretsEngineProvider;
import java.util.LinkedList;
import java.util.List;

public class DbEngineProvider
implements SecretsEngineProvider<DbSecretsRx>,
InjectionProvider {
    private static final List<InjectionProvider.InjectionType<?>> INJECTABLES;

    public Engine<DbSecretsRx> supportedEngine() {
        return DbSecretsRx.ENGINE;
    }

    public DbSecretsRx createSecrets(Config config, RestApi restApi, String mount) {
        return new DbSecretsRxImpl(restApi, mount);
    }

    public List<InjectionProvider.InjectionType<?>> injectables() {
        return INJECTABLES;
    }

    static {
        LinkedList<InjectionProvider.InjectionType> injectables = new LinkedList<InjectionProvider.InjectionType>();
        injectables.add(InjectionProvider.InjectionType.create(DbSecretsRx.class, (vault, config, instanceConfig) -> instanceConfig.vaultPath().map(it -> (DbSecretsRx)vault.secrets(DbSecretsRx.ENGINE, it)).orElseGet(() -> (DbSecretsRx)vault.secrets(DbSecretsRx.ENGINE))));
        injectables.add(InjectionProvider.InjectionType.create(DbSecrets.class, (vault, config, instanceConfig) -> {
            DbSecretsRx rx = instanceConfig.vaultPath().map(it -> (DbSecretsRx)vault.secrets(DbSecretsRx.ENGINE, it)).orElseGet(() -> (DbSecretsRx)vault.secrets(DbSecretsRx.ENGINE));
            return new DbSecretsImpl(rx);
        }));
        INJECTABLES = List.copyOf(injectables);
    }
}

