/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.common.reactive.Single;
import io.helidon.integrations.vault.Engine;
import io.helidon.integrations.vault.ListSecrets;
import io.helidon.integrations.vault.SecretsRx;
import io.helidon.integrations.vault.VaultOptionalResponse;
import io.helidon.integrations.vault.secrets.database.DbConfigure;
import io.helidon.integrations.vault.secrets.database.DbCreateRole;
import io.helidon.integrations.vault.secrets.database.DbCredentials;
import io.helidon.integrations.vault.secrets.database.DbDelete;
import io.helidon.integrations.vault.secrets.database.DbDeleteRole;
import io.helidon.integrations.vault.secrets.database.DbGet;
import java.util.Optional;
import java.util.function.Function;

public interface DbSecretsRx
extends SecretsRx {
    public static final Engine<DbSecretsRx> ENGINE = Engine.create(DbSecretsRx.class, (String)"database", (String)"database");

    public Single<VaultOptionalResponse<ListSecrets.Response>> list(ListSecrets.Request var1);

    default public Single<Optional<DbCredentials>> get(String name) {
        return this.get(DbGet.Request.builder().name(name)).map(it -> it.entity().map(Function.identity()));
    }

    public Single<VaultOptionalResponse<DbGet.Response>> get(DbGet.Request var1);

    public Single<DbCreateRole.Response> createRole(DbCreateRole.Request var1);

    public Single<DbConfigure.Response> configure(DbConfigure.Request<?> var1);

    default public Single<DbDelete.Response> delete(String name) {
        return this.delete(DbDelete.Request.builder().name(name));
    }

    public Single<DbDelete.Response> delete(DbDelete.Request var1);

    default public Single<DbDeleteRole.Response> deleteRole(String name) {
        return this.deleteRole(DbDeleteRole.Request.builder().name(name));
    }

    public Single<DbDeleteRole.Response> deleteRole(DbDeleteRole.Request var1);
}

