/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.common.rest.ApiJsonParser;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultRequest;
import io.helidon.integrations.vault.secrets.database.DbCredentials;
import java.util.Map;
import java.util.Optional;
import javax.json.JsonObject;

public final class DbGet {
    private DbGet() {
    }

    public static final class Response
    extends ApiJsonParser
    implements DbCredentials {
        private final String name;
        private final Map<String, String> values;

        private Response(String name, JsonObject object) {
            this.name = name;
            this.values = Response.toMap((JsonObject)object, (String)"data");
        }

        static Response create(String path, JsonObject json) {
            return new Response(path, json);
        }

        public String path() {
            return this.name;
        }

        public Optional<String> value(String key) {
            return Optional.ofNullable(this.values.get(key));
        }

        public Map<String, String> values() {
            return this.values;
        }
    }

    public static final class Request
    extends VaultRequest<Request> {
        private String name;

        private Request() {
        }

        public static Request builder() {
            return new Request();
        }

        public Request name(String name) {
            this.name = name;
            return this;
        }

        String name() {
            if (this.name == null) {
                throw new VaultApiException("DbGet.Request name must be defined");
            }
            return this.name;
        }
    }
}

