/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.openapi.ui;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.integrations.openapi.ui.OpenApiUi;
import io.helidon.integrations.openapi.ui.OpenApiUiConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.openapi.ui.OpenApiUiConfigBlueprint")
public interface OpenApiUiConfig
extends OpenApiUiConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenApiUiConfig instance) {
        return (Builder)OpenApiUiConfig.builder().from(instance);
    }

    public static OpenApiUiConfig create(Config config) {
        return ((Builder)OpenApiUiConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static OpenApiUiConfig create(io.helidon.common.config.Config config) {
        return OpenApiUiConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static OpenApiUiConfig create() {
        return OpenApiUiConfig.builder().buildPrototype();
    }

    @Override
    public Map<String, String> options();

    @Override
    public boolean isEnabled();

    @Override
    public Optional<String> webContext();

    public static class Builder
    extends BuilderBase<Builder, OpenApiUiConfig>
    implements io.helidon.common.Builder<Builder, OpenApiUi> {
        private Builder() {
        }

        public OpenApiUiConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OpenApiUiConfigImpl(this);
        }

        public OpenApiUi build() {
            return OpenApiUi.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OpenApiUiConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean isEnabled = true;
        private boolean isOptionsMutated;
        private Config config;
        private Map<String, String> options = new LinkedHashMap<String, String>();
        private String webContext;

        protected BuilderBase() {
        }

        public BUILDER from(OpenApiUiConfig prototype) {
            if (!this.isOptionsMutated) {
                this.options.clear();
            }
            this.addOptions(prototype.options());
            this.isEnabled(prototype.isEnabled());
            this.webContext(prototype.webContext());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isOptionsMutated) {
                if (builder.isOptionsMutated) {
                    this.addOptions(builder.options());
                }
            } else {
                this.options(builder.options());
            }
            this.isEnabled(builder.isEnabled());
            builder.webContext().ifPresent(this::webContext);
            this.config = builder.config().map(Config::config).orElse(this.config);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("options").detach().asMap().ifPresent(this::options);
            config.get("enabled").asBoolean().ifPresent(this::isEnabled);
            config.get("web-context").asString().ifPresent(this::webContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER options(Map<String, String> options) {
            Objects.requireNonNull(options);
            this.options.clear();
            this.options.putAll(options);
            this.isOptionsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOptions(Map<String, String> options) {
            Objects.requireNonNull(options);
            this.options.putAll(options);
            this.isOptionsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWebContext() {
            this.webContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER webContext(String webContext) {
            Objects.requireNonNull(webContext);
            this.webContext = webContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Map<String, String> options() {
            return this.options;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public Optional<String> webContext() {
            return Optional.ofNullable(this.webContext);
        }

        public String toString() {
            return "OpenApiUiConfigBuilder{options=" + String.valueOf(this.options) + ",isEnabled=" + this.isEnabled + ",webContext=" + this.webContext + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        BUILDER webContext(Optional<String> webContext) {
            Objects.requireNonNull(webContext);
            this.webContext = webContext.orElse(this.webContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OpenApiUiConfigImpl
        implements OpenApiUiConfig,
        Supplier<OpenApiUi> {
            private final boolean isEnabled;
            private final Map<String, String> options;
            private final Optional<String> webContext;

            protected OpenApiUiConfigImpl(BuilderBase<?, ?> builder) {
                this.options = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.options()));
                this.isEnabled = builder.isEnabled();
                this.webContext = builder.webContext().map(Function.identity());
            }

            public OpenApiUi build() {
                return OpenApiUi.create(this);
            }

            @Override
            public OpenApiUi get() {
                return this.build();
            }

            @Override
            public Map<String, String> options() {
                return this.options;
            }

            @Override
            public boolean isEnabled() {
                return this.isEnabled;
            }

            @Override
            public Optional<String> webContext() {
                return this.webContext;
            }

            public String toString() {
                return "OpenApiUiConfig{options=" + String.valueOf(this.options) + ",isEnabled=" + this.isEnabled + ",webContext=" + String.valueOf(this.webContext) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenApiUiConfig)) {
                    return false;
                }
                OpenApiUiConfig other = (OpenApiUiConfig)o;
                return Objects.equals(this.options, other.options()) && this.isEnabled == other.isEnabled() && Objects.equals(this.webContext, other.webContext());
            }

            public int hashCode() {
                return Objects.hash(this.options, this.isEnabled, this.webContext);
            }
        }
    }
}

