/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.authentication.instance;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import io.helidon.common.LazyValue;
import io.helidon.common.Weight;
import io.helidon.integrations.oci.HelidonOci;
import io.helidon.integrations.oci.OciConfig;
import io.helidon.integrations.oci.spi.OciAuthenticationMethod;
import io.helidon.service.registry.Service;
import java.util.Optional;
import java.util.function.Supplier;

@Weight(value=60.0)
@Service.Provider
class AuthenticationMethodInstancePrincipal
implements OciAuthenticationMethod {
    private static final System.Logger LOGGER = System.getLogger(AuthenticationMethodInstancePrincipal.class.getName());
    private static final String METHOD = "instance-principal";
    private final LazyValue<Optional<BasicAuthenticationDetailsProvider>> provider;

    AuthenticationMethodInstancePrincipal(OciConfig config, Supplier<Optional<InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder>> builder) {
        this.provider = AuthenticationMethodInstancePrincipal.createProvider(config, builder);
    }

    public String method() {
        return METHOD;
    }

    public Optional<BasicAuthenticationDetailsProvider> provider() {
        return (Optional)this.provider.get();
    }

    private static LazyValue<Optional<BasicAuthenticationDetailsProvider>> createProvider(OciConfig config, Supplier<Optional<InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder>> builder) {
        return LazyValue.create(() -> {
            if (HelidonOci.imdsAvailable((OciConfig)config)) {
                return ((Optional)builder.get()).map(InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder::build);
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "OCI Metadata service is not available, instance principal cannot be used.");
            }
            return Optional.empty();
        });
    }
}

