/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.integrations.langchain4j.codegen.IntrospectionBlueprintBuilder;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import io.helidon.integrations.langchain4j.codegen.ModelCodegenHelper;
import java.util.Map;
import java.util.Optional;

class LlmNestedBlueprintBuilder
extends IntrospectionBlueprintBuilder {
    private final ClassModel.Builder classModel = ClassModel.builder();
    private final String configRoot;

    private LlmNestedBlueprintBuilder(TypeInfo modelType, TypeInfo modelBuilderType, TypeInfo lc4jNestedParentTypeInfo, String configRoot, RoundContext ctx) {
        super(ctx, modelType, lc4jNestedParentTypeInfo, modelBuilderType);
        this.configRoot = configRoot + "." + ModelCodegenHelper.providerConfigKeyFromClassName(lc4jNestedParentTypeInfo);
    }

    static LlmNestedBlueprintBuilder create(RoundContext ctx, String configRoot, TypedElementInfo srcMethod, TypeInfo lc4jProviderTypeInfo) {
        Optional nestedCfgAnnotation = srcMethod.findAnnotation(LangchainTypes.MODEL_NESTED_CONFIG);
        TypeInfo modelType = (TypeInfo)nestedCfgAnnotation.flatMap(a -> a.typeValue()).filter(typeName -> !typeName.equals((Object)TypeNames.BOXED_VOID)).flatMap(arg_0 -> ((RoundContext)ctx).typeInfo(arg_0)).orElseThrow();
        TypeInfo modelBuilderType = nestedCfgAnnotation.flatMap(a -> a.stringValue("builderMethod")).map(v -> ModelCodegenHelper.resolveModelBuilderType(ctx, modelType, v)).orElseThrow();
        Optional<String> nestedParent = nestedCfgAnnotation.flatMap(a -> a.typeValue("parent")).filter(t -> !t.equals((Object)TypeNames.BOXED_VOID)).flatMap(arg_0 -> ((RoundContext)ctx).typeInfo(arg_0));
        LlmNestedBlueprintBuilder builder = new LlmNestedBlueprintBuilder(modelType, modelBuilderType, nestedParent.orElse((String)lc4jProviderTypeInfo), configRoot, ctx);
        String namePrefix = nestedParent.map(info -> info.typeName().className().replace("NestedParentBlueprint", "")).orElse(modelType.typeName().className());
        TypeName blueprintTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(lc4jProviderTypeInfo.typeName().packageName())).className(namePrefix + "ConfigBlueprint")).build();
        builder.initClassModel(blueprintTypeName, lc4jProviderTypeInfo.typeName(), nestedParent.map(info -> info.typeName()));
        return builder;
    }

    @Override
    protected String configRoot() {
        return this.configRoot;
    }

    @Override
    protected Map<String, TypedElementInfo> resolveOverriddenProperties() {
        return Map.of();
    }

    @Override
    protected ClassModel.Builder classModelBuilder() {
        return this.classModel;
    }
}

