/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.db.h2;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.UUID;

@Substitute
@TargetClass(className="org.h2.util.Bits")
public final class BitsSubstitution {
    private static void printStackTrace(String message) {
        new Exception(message).printStackTrace();
    }

    @Substitute
    public static int compareNotNull(char[] data1, char[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len1 = data1.length;
        int len2 = data2.length;
        if (len1 != len2) {
            return len1 > len2 ? 1 : -1;
        }
        for (int i = 0; i < len1; ++i) {
            char b = data1[i];
            char b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return 0;
    }

    @Substitute
    public static int compareNotNullSigned(byte[] data1, byte[] data2) {
        BitsSubstitution.printStackTrace("intentional");
        if (data1 == data2) {
            return 0;
        }
        int len1 = data1.length;
        int len2 = data2.length;
        if (len1 != len2) {
            return len1 > len2 ? 1 : -1;
        }
        for (int i = 0; i < len1; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return 0;
    }

    @Substitute
    public static int compareNotNullUnsigned(byte[] data1, byte[] data2) {
        BitsSubstitution.printStackTrace("intentional");
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            int b = data1[i] & 0xFF;
            int b2 = data2[i] & 0xFF;
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    @Substitute
    public static int readInt(byte[] buff, int pos) {
        BitsSubstitution.printStackTrace("intentional");
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }

    @Substitute
    public static int readIntLE(byte[] buff, int pos) {
        BitsSubstitution.printStackTrace("intentional");
        return (buff[pos++] & 0xFF) + ((buff[pos++] & 0xFF) << 8) + ((buff[pos++] & 0xFF) << 16) + (buff[pos] << 24);
    }

    @Substitute
    public static long readLong(byte[] buff, int pos) {
        BitsSubstitution.printStackTrace("intentional");
        BitsSubstitution.printStackTrace("intentional");
        return ((long)BitsSubstitution.readInt(buff, pos) << 32) + ((long)BitsSubstitution.readInt(buff, pos + 4) & 0xFFFFFFFFL);
    }

    public static long readLongLE(byte[] buff, int pos) {
        return ((long)BitsSubstitution.readIntLE(buff, pos) & 0xFFFFFFFFL) + ((long)BitsSubstitution.readIntLE(buff, pos + 4) << 32);
    }

    @Substitute
    public static double readDouble(byte[] buff, int pos) {
        return Double.longBitsToDouble(BitsSubstitution.readLong(buff, pos));
    }

    @Substitute
    public static double readDoubleLE(byte[] buff, int pos) {
        return Double.longBitsToDouble(BitsSubstitution.readLongLE(buff, pos));
    }

    @Substitute
    public static byte[] uuidToBytes(long msb, long lsb) {
        BitsSubstitution.printStackTrace("intentional");
        byte[] buff = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buff[i] = (byte)(msb >> 8 * (7 - i) & 0xFFL);
            buff[8 + i] = (byte)(lsb >> 8 * (7 - i) & 0xFFL);
        }
        return buff;
    }

    @Substitute
    public static byte[] uuidToBytes(UUID uuid) {
        BitsSubstitution.printStackTrace("intentional");
        return BitsSubstitution.uuidToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @Substitute
    public static void writeInt(byte[] buff, int pos, int x) {
        BitsSubstitution.printStackTrace("intentional");
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos] = (byte)x;
    }

    public static void writeIntLE(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)x;
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)(x >> 16);
        buff[pos] = (byte)(x >> 24);
    }

    @Substitute
    public static void writeLong(byte[] buff, int pos, long x) {
        BitsSubstitution.printStackTrace("intentional");
        BitsSubstitution.writeInt(buff, pos, (int)(x >> 32));
        BitsSubstitution.writeInt(buff, pos + 4, (int)x);
    }

    public static void writeLongLE(byte[] buff, int pos, long x) {
        BitsSubstitution.writeIntLE(buff, pos, (int)x);
        BitsSubstitution.writeIntLE(buff, pos + 4, (int)(x >> 32));
    }

    @Substitute
    public static void writeDouble(byte[] buff, int pos, double x) {
        BitsSubstitution.writeLong(buff, pos, Double.doubleToRawLongBits(x));
    }

    public static void writeDoubleLE(byte[] buff, int pos, double x) {
        BitsSubstitution.writeLongLE(buff, pos, Double.doubleToRawLongBits(x));
    }

    private BitsSubstitution() {
    }
}

