/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.referencecountedcontext;

import io.helidon.integrations.cdi.referencecountedcontext.ReferenceCounted;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Deprecated(forRemoval=true, since="3.0.3")
public final class ReferenceCountedContext
implements AlterableContext {
    private static final ThreadLocal<Map<ReferenceCountedContext, Map<Contextual<?>, Instance<?>>>> ALL_INSTANCES = ThreadLocal.withInitial(() -> new HashMap());

    ReferenceCountedContext() {
        ALL_INSTANCES.get().put(this, new HashMap());
    }

    public int decrementReferenceCount(Contextual<?> c) {
        return this.decrementReferenceCount(c, 1);
    }

    public int decrementReferenceCount(Contextual<?> c, int amount) {
        int returnValue;
        if (amount < 0) {
            throw new IllegalArgumentException("amount < 0: " + amount);
        }
        if (c == null) {
            returnValue = 0;
        } else {
            Map<Contextual<?>, Instance<?>> instances = ALL_INSTANCES.get().get(this);
            if (instances == null) {
                returnValue = 0;
            } else {
                Instance<?> instance = instances.get(c);
                if (instance == null) {
                    returnValue = 0;
                } else {
                    returnValue = instance.decrementReferenceCount(amount);
                    if (returnValue <= 0) {
                        instances.remove(c);
                    }
                }
            }
        }
        return returnValue;
    }

    public int getReferenceCount(Contextual<?> c) {
        Instance<?> instance;
        Map<Contextual<?>, Instance<?>> instances;
        int returnValue = c == null ? 0 : ((instances = ALL_INSTANCES.get().get(this)) == null ? 0 : ((instance = instances.get(c)) == null ? 0 : Math.max(0, instance.getReferenceCount())));
        return returnValue;
    }

    public void destroy(Contextual<?> contextual) {
        this.decrementReferenceCount(contextual);
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null, false);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> cc) {
        return this.get(contextual, cc, true);
    }

    private <T> T get(Contextual<T> contextual, CreationalContext<T> cc, boolean maybeCreate) {
        Object returnValue;
        if (contextual == null) {
            returnValue = null;
        } else {
            Map<ReferenceCountedContext, Map<Contextual<?>, Instance<?>>> allInstances = ALL_INSTANCES.get();
            assert (allInstances != null);
            Map<Contextual<?>, Instance<?>> instances = allInstances.get(this);
            if (instances == null && maybeCreate) {
                instances = new HashMap();
                allInstances.put(this, instances);
            }
            if (instances == null) {
                returnValue = null;
            } else {
                Instance<?> temp = instances.get(contextual);
                Instance<Object> instance = temp;
                if (instance == null) {
                    if (maybeCreate) {
                        instance = new Instance<T>(contextual, cc);
                        instances.put(contextual, instance);
                        returnValue = instance.get();
                    } else {
                        returnValue = null;
                    }
                } else {
                    returnValue = instance.get();
                }
            }
        }
        return (T)returnValue;
    }

    public Class<? extends Annotation> getScope() {
        return ReferenceCounted.class;
    }

    public boolean isActive() {
        return true;
    }

    public static ReferenceCountedContext getInstanceFrom(BeanManager beanManager) {
        Objects.requireNonNull(beanManager);
        return (ReferenceCountedContext)beanManager.getContext(ReferenceCounted.class);
    }

    private static final class Instance<T> {
        private T object;
        private int referenceCount;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        private Instance(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            this.contextual = Objects.requireNonNull(contextual);
            this.creationalContext = creationalContext;
            this.object = this.contextual.create(creationalContext);
        }

        private T get() {
            if (this.referenceCount < 0) {
                throw new IllegalStateException("this.referenceCount < 0: " + this.referenceCount);
            }
            if (this.referenceCount < Integer.MAX_VALUE) {
                ++this.referenceCount;
            }
            return this.object;
        }

        private int getReferenceCount() {
            return this.referenceCount;
        }

        private int decrementReferenceCount(int amount) {
            if (amount < 0) {
                throw new IllegalArgumentException("amount < 0: " + amount);
            }
            if (this.referenceCount > 0) {
                this.referenceCount = Math.max(0, this.referenceCount - amount);
                if (this.referenceCount == 0) {
                    this.contextual.destroy(this.object, this.creationalContext);
                    if (this.creationalContext != null) {
                        this.creationalContext.release();
                    }
                    this.object = null;
                    this.referenceCount = -1;
                }
            } else {
                throw new IllegalStateException("this.referenceCount <= 0: " + this.referenceCount);
            }
            return this.referenceCount;
        }
    }
}

