/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.webserver;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.webserver.AbstractParametersProvider;
import io.helidon.declarative.codegen.http.webserver.ParameterCodegenContext;
import io.helidon.declarative.codegen.http.webserver.spi.HttpParameterCodegenProvider;
import io.helidon.service.codegen.DefaultsCodegen;
import io.helidon.service.codegen.DefaultsParams;
import io.helidon.service.codegen.FieldHandler;
import java.util.Optional;

class ParamProviderHttpQuery
extends AbstractParametersProvider
implements HttpParameterCodegenProvider {
    ParamProviderHttpQuery() {
    }

    @Override
    public boolean codegen(ParameterCodegenContext ctx) {
        Optional<Annotation> first = ctx.annotations().stream().filter(it -> HttpTypes.HTTP_QUERY_PARAM_ANNOTATION.equals((Object)it.typeName())).findFirst();
        if (first.isEmpty()) {
            return false;
        }
        Optional defaultCode = DefaultsCodegen.findDefault(ctx.annotations(), (TypeName)HttpTypes.HTTP_QUERY_PARAM_ANNOTATION);
        Annotation queryParam = first.get();
        String queryParamName = (String)queryParam.value().orElseThrow(() -> new CodegenException("@QueryParam annotation must have a value."));
        ContentBuilder<?> contentBuilder = ctx.contentBuilder();
        contentBuilder.addContent(ctx.serverRequestParamName()).addContent(".query()");
        this.codegenFromParameters(contentBuilder, ctx.parameterType(), queryParamName, ctx.parameterType().isOptional() || defaultCode.isPresent());
        if (defaultCode.isPresent()) {
            DefaultsCodegen.DefaultCode defaultInfo = (DefaultsCodegen.DefaultCode)defaultCode.get();
            if (defaultInfo.requiresMapper()) {
                this.ensureMapperField(ctx);
            }
            DefaultsParams params = ((DefaultsParams.Builder)((DefaultsParams.Builder)((DefaultsParams.Builder)DefaultsParams.builder().contextField(ctx.serverRequestParamName() + ".query()")).mapperQualifier("uri/query")).mappersField("mappers")).build();
            DefaultsCodegen.codegenOptional(contentBuilder, (DefaultsCodegen.DefaultCode)((DefaultsCodegen.DefaultCode)defaultCode.get()), (FieldHandler)ctx.fieldHandler(), (DefaultsParams)params);
        }
        contentBuilder.addContentLine(";");
        return true;
    }

    @Override
    String providerType() {
        return "Query parameter";
    }
}

