/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.restclient;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.DelcarativeConfigSupport;
import io.helidon.declarative.codegen.http.HttpFields;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.RestExtensionBase;
import io.helidon.declarative.codegen.http.restclient.RestClientTypes;
import io.helidon.declarative.codegen.model.http.ClientEndpoint;
import io.helidon.declarative.codegen.model.http.ComputedHeader;
import io.helidon.declarative.codegen.model.http.HeaderValue;
import io.helidon.declarative.codegen.model.http.HttpAnnotated;
import io.helidon.declarative.codegen.model.http.RestEndpoint;
import io.helidon.declarative.codegen.model.http.RestMethod;
import io.helidon.declarative.codegen.model.http.RestMethodParameter;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class RestClientExtension
extends RestExtensionBase
implements RegistryCodegenExtension {
    static final TypeName GENERATOR = TypeName.create(RestClientExtension.class);
    private final RegistryCodegenContext ctx;

    RestClientExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        Collection clientApis = roundContext.annotatedTypes(RestClientTypes.REST_CLIENT_ENDPOINT);
        List endpoints = clientApis.stream().map(this::toEndpoint).collect(Collectors.toUnmodifiableList());
        for (ClientEndpoint endpoint : endpoints) {
            this.process(roundContext, endpoint);
        }
    }

    private ClientEndpoint toEndpoint(TypeInfo typeInfo) {
        ClientEndpoint.Builder builder = (ClientEndpoint.Builder)ClientEndpoint.builder().type(typeInfo);
        HashSet<Annotation> typeAnnotations = new HashSet<Annotation>(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo));
        builder.annotations(typeAnnotations);
        Annotations.findFirst((TypeName)RestClientTypes.REST_CLIENT_ENDPOINT, typeAnnotations).ifPresent(endpoint -> {
            endpoint.stringValue().filter(Predicate.not(String::isBlank)).ifPresent(arg_0 -> ((ClientEndpoint.Builder)builder).uri(arg_0));
            builder.configKey(endpoint.stringValue("configKey").filter(Predicate.not(String::isBlank)).orElseGet(() -> typeInfo.typeName().fqName()));
            endpoint.stringValue("clientName").filter(Predicate.not(String::isBlank)).ifPresent(arg_0 -> ((ClientEndpoint.Builder)builder).clientName(arg_0));
        });
        this.path((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.produces((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.consumes((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.headers((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder, RestClientTypes.REST_CLIENT_HEADERS, RestClientTypes.REST_CLIENT_HEADER);
        this.computedHeaders((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder, RestClientTypes.REST_CLIENT_COMPUTED_HEADERS, RestClientTypes.REST_CLIENT_COMPUTED_HEADER);
        LinkedHashMap<MethodSignature, MethodOrigin> discoveredMethods = new LinkedHashMap<MethodSignature, MethodOrigin>();
        typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isDefault)).forEach(it -> discoveredMethods.put(MethodSignature.create(it), new MethodOrigin(typeInfo, (TypedElementInfo)it)));
        typeInfo.interfaceTypeInfo().forEach(iface -> iface.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isDefault)).forEach(it -> discoveredMethods.putIfAbsent(MethodSignature.create(it), new MethodOrigin((TypeInfo)iface, (TypedElementInfo)it))));
        discoveredMethods.forEach((sig, origin) -> builder.addMethod(this.toEndpointMethod(origin.type(), origin.method(), builder)));
        return builder.build();
    }

    private RestMethod toEndpointMethod(TypeInfo typeInfo, TypedElementInfo method, ClientEndpoint.Builder endpointBuilder) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo, (TypedElementInfo)method));
        RestMethod.Builder builder = (RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)RestMethod.builder().returnType(method.typeName())).type(typeInfo)).name(method.elementName())).uniqueName(method.elementName())).method(method)).annotations(annotations)).httpMethod(this.httpMethodFromAnnotation(method, this.getMetaAnnotated(method, HttpTypes.HTTP_METHOD_ANNOTATION, annotations)));
        this.path((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.consumes((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.produces((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.headers((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder, RestClientTypes.REST_CLIENT_HEADERS, RestClientTypes.REST_CLIENT_HEADER);
        this.computedHeaders((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder, RestClientTypes.REST_CLIENT_COMPUTED_HEADERS, RestClientTypes.REST_CLIENT_COMPUTED_HEADER);
        if (builder.consumes().isEmpty()) {
            builder.consumes(endpointBuilder.consumes());
        }
        if (builder.produces().isEmpty()) {
            builder.produces(endpointBuilder.produces());
        }
        builder.addHeaders(endpointBuilder.headers());
        builder.addComputedHeaders(endpointBuilder.computedHeaders());
        int index = 0;
        for (TypedElementInfo parameterInfo : method.parameterArguments()) {
            this.processEndpointParameter(typeInfo, method, parameterInfo, builder, index);
            ++index;
        }
        return builder.build();
    }

    private Annotation getMetaAnnotated(TypedElementInfo method, TypeName metaAnnotation, Set<Annotation> annotations) {
        return this.findMetaAnnotated(metaAnnotation, annotations).orElseThrow(() -> new CodegenException("Cannot find meta annotation " + metaAnnotation.fqName() + " on method", method.originatingElementValue()));
    }

    private void processEndpointParameter(TypeInfo typeInfo, TypedElementInfo methodInfo, TypedElementInfo parameterInfo, RestMethod.Builder method, int index) {
        HashSet annotations = new HashSet(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo, (TypedElementInfo)methodInfo, (TypedElementInfo)parameterInfo, (int)index));
        RestMethodParameter parameter = ((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)RestMethodParameter.builder().annotations(annotations)).name(parameterInfo.elementName())).typeName(parameterInfo.typeName())).index(index)).method(methodInfo)).type(typeInfo)).parameter(parameterInfo)).build();
        method.addParameter(parameter);
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_HEADER_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addHeaderParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_QUERY_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addQueryParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_PATH_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addPathParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_ENTITY_ANNOTATION, annotations).isPresent()) {
            method.entityParameter(parameter);
        }
    }

    private void process(RegistryRoundContext roundContext, ClientEndpoint endpoint) {
        TypeInfo type = endpoint.type();
        if (type.kind() != ElementKind.INTERFACE) {
            throw new CodegenException("Types annotated with " + RestClientTypes.REST_CLIENT_ENDPOINT.classNameWithEnclosingNames() + " must be interfaces. This type is: " + String.valueOf(type.kind()), type.originatingElementValue());
        }
        String classNameBase = type.typeName().classNameWithEnclosingNames().replace('.', '_');
        String className = classNameBase + "__DeclarativeClient";
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(type.typeName().packageName())).className(className)).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)type.typeName(), (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)type.typeName(), (TypeName)generatedType, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(generatedType).addInterface(type.typeName())).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(RestClientTypes.REST_CLIENT_QUALIFIER_INSTANCE);
        Constructor.Builder constructor = this.constructor(classModel, endpoint);
        FieldHandler fieldHandler = FieldHandler.create((ClassModel.Builder)classModel, (Constructor.Builder)constructor);
        classModel.addField(webClient -> webClient.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(RestClientTypes.WEB_CLIENT).name("client"));
        classModel.addField(webClient -> webClient.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(String.class).name("baseUri"));
        classModel.addField(webClient -> webClient.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(RestClientTypes.REST_CLIENT_ERROR_HANDLING).name("errorHandling"));
        Map<String, String> headerProducerFields = this.headerProducers(fieldHandler, (RestEndpoint)endpoint);
        for (RestMethod method : endpoint.methods()) {
            this.generateMethod(fieldHandler, classModel, method, headerProducerFields);
        }
        classModel.addConstructor(constructor);
        roundContext.addGeneratedType(generatedType, classModel, type.typeName(), new Object[]{type.originatingElementValue()});
    }

    private void generateMethod(FieldHandler fieldHandler, ClassModel.Builder classModel, RestMethod method, Map<String, String> headerProducers) {
        classModel.addMethod(restMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)restMethod.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).name(method.name())).returnType(method.returnType()).update(it -> this.generateMethodParamsAndBody(fieldHandler, (Method.Builder)it, method, headerProducers)));
    }

    private void generateMethodParamsAndBody(FieldHandler fieldHandler, Method.Builder it, RestMethod method, Map<String, String> headerProducers) {
        boolean hasResponse;
        List consumes;
        method.parameters().forEach(param -> it.addParameter(newParam -> ((Parameter.Builder)newParam.name(param.name())).type(param.typeName())));
        if (method.pathParameters().isEmpty()) {
            path = method.path().orElse(null);
            it.addContent("var declarative__uri = baseUri");
            if (path == null) {
                it.addContentLine(";");
            } else {
                ((Method.Builder)((Method.Builder)it.addContent(" + \"")).addContent((String)((Object)path))).addContentLine("\";");
            }
        } else {
            path = (String)method.path().orElseThrow(() -> new CodegenException("@Http.PathParameter defined on a method,yet it does not have a @Http.Path annotation.", method.method().originatingElementValue()));
            ArrayList<Record> parts = new ArrayList<Record>();
            StringBuilder currentPart = new StringBuilder();
            boolean currentPartIsName = false;
            for (char c : ((String)((Object)path)).toCharArray()) {
                if (c == '{') {
                    if (!currentPart.isEmpty()) {
                        if (currentPartIsName) {
                            parts.add(new NamePart(currentPart.toString()));
                        } else {
                            parts.add(new StringPart(currentPart.toString()));
                        }
                        currentPart.setLength(0);
                    }
                    currentPartIsName = true;
                    continue;
                }
                if (c == '}') {
                    parts.add(new NamePart(currentPart.toString()));
                    currentPart.setLength(0);
                    currentPartIsName = false;
                    continue;
                }
                currentPart.append(c);
            }
            if (!currentPart.isEmpty()) {
                parts.add(new StringPart(currentPart.toString()));
            }
            HashMap<String, String> pathParamNameToParameterName = new HashMap<String, String>();
            for (RestMethodParameter pathParameter : method.pathParameters()) {
                String paramName = pathParameter.name();
                String pathParam = this.pathParamNameFromPathParam(pathParameter);
                pathParamNameToParameterName.put(pathParam, paramName);
            }
            ((Method.Builder)it.addContent("var declarative__uri = baseUri")).addContent(parts.stream().map(part -> part.codegen(pathParamNameToParameterName)).collect(Collectors.joining(" + ", " + ", "")));
            it.addContentLine(";");
        }
        it.addContent("var declarative__builder = client.");
        if (method.httpMethod().builtIn()) {
            ((Method.Builder)it.addContent(method.httpMethod().name().toLowerCase(Locale.ROOT))).addContentLine("(declarative__uri);");
        } else {
            ((Method.Builder)((Method.Builder)it.addContent("method(")).addContent(HttpFields.ensureHttpMethodConstant(fieldHandler, method.httpMethod().name()))).addContentLine(").path(declarative__uri);");
        }
        for (HeaderValue header : method.headers()) {
            ((Method.Builder)((Method.Builder)it.addContent("declarative__builder.header(")).addContent(HttpFields.ensureHeaderValueConstant(fieldHandler, header))).addContentLine(");");
        }
        for (ComputedHeader computedHeader : method.computedHeaders()) {
            String headerNameConstant = HttpFields.ensureHeaderNameConstant(fieldHandler, computedHeader.headerName());
            ((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(headerProducers.get(computedHeader.serviceName()))).addContent(".apply(")).addContent(headerNameConstant)).addContent(").ifPresent(declarative__it -> declarative__builder.header(declarative__it));");
        }
        for (RestMethodParameter headerParameter : method.headerParameters()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent("declarative__builder.header(")).addContent(HttpTypes.HTTP_HEADER_VALUES)).addContent(".create(")).addContent(HttpFields.ensureHeaderNameConstant(fieldHandler, this.headerNameFromHeaderParam(headerParameter)))).addContent(", ")).addContent(headerParameter.name())).addContentLine("));");
        }
        for (RestMethodParameter parameter : method.queryParameters()) {
            boolean optional = parameter.typeName().isOptional();
            String queryParamName = this.queryParameterName(parameter);
            if (optional) {
                ((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(parameter.name())).addContent(".ifPresent(declarative__it -> declarative__builder.queryParam(\"")).addContent(queryParamName)).addContent("\", String.valueOf(declarative__it)));");
                continue;
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent("declarative__builder.queryParam(\"")).addContent(queryParamName)).addContent("\", String.valueOf(")).addContent(parameter.name())).addContentLine(")));");
        }
        List produces = method.produces();
        if (!produces.isEmpty()) {
            it.addContent("declarative__builder.accept(");
            it.addContent(produces.stream().map(mediaType -> HttpFields.ensureHttpMediaTypeConstant(fieldHandler, mediaType)).collect(Collectors.joining(", ")));
            it.addContentLine(");");
        }
        if ((consumes = method.consumes()).size() == 1) {
            ((Method.Builder)((Method.Builder)it.addContent("declarative__builder.contentType(")).addContent(HttpFields.ensureHttpMediaTypeConstant(fieldHandler, (String)consumes.getFirst()))).addContentLine(");");
        }
        boolean hasEntity = method.entityParameter().isPresent();
        boolean bl = hasResponse = !method.returnType().equals((Object)TypeNames.BOXED_VOID) && !method.returnType().equals((Object)TypeNames.PRIMITIVE_VOID);
        if (hasEntity && hasResponse) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent("var declarative__response = declarative__builder.submit(")).addContent(((RestMethodParameter)method.entityParameter().get()).name())).addContent(", ")).addContent(method.returnType())).addContentLine(".class);");
        } else if (hasEntity) {
            ((Method.Builder)((Method.Builder)it.addContent("try (var declarative__response = declarative__builder.submit(")).addContent(((RestMethodParameter)method.entityParameter().get()).name())).addContentLine(")) {");
        } else if (hasResponse) {
            ((Method.Builder)((Method.Builder)it.addContent("var declarative__response = declarative__builder.request(")).addContent(method.returnType())).addContentLine(".class);");
        } else {
            it.addContentLine("try (var declarative__response = declarative__builder.request()) {");
        }
        it.addContentLine("var declarative__headers = declarative__builder.headers();");
        if (hasResponse) {
            ((Method.Builder)((Method.Builder)it.addContent("errorHandling.handle(declarative__uri, declarative__headers, declarative__response, ")).addContent(method.returnType())).addContentLine(".class);");
        } else {
            it.addContentLine("errorHandling.handle(declarative__uri, declarative__headers, declarative__response);");
        }
        if (hasResponse) {
            it.addContentLine("return declarative__response.entity();");
        } else {
            it.addContentLine("}");
        }
    }

    private String queryParameterName(RestMethodParameter parameter) {
        return (String)Annotations.findFirst((TypeName)HttpTypes.HTTP_QUERY_PARAM_ANNOTATION, (Collection)parameter.annotations()).flatMap(rec$ -> ((Annotation)rec$).value()).orElseThrow(() -> new CodegenException("Parameter is recognized as @Http.QueryParam yet it is not annotated: " + parameter.name(), parameter.parameter().originatingElementValue()));
    }

    private String pathParamNameFromPathParam(RestMethodParameter parameter) {
        return (String)Annotations.findFirst((TypeName)HttpTypes.HTTP_PATH_PARAM_ANNOTATION, (Collection)parameter.annotations()).flatMap(rec$ -> ((Annotation)rec$).value()).orElseThrow(() -> new CodegenException("Parameter is recognized as @Http.HeaderParam yet it is not annotated: " + parameter.name(), parameter.parameter().originatingElementValue()));
    }

    private String headerNameFromHeaderParam(RestMethodParameter parameter) {
        for (Annotation annotation : parameter.annotations()) {
            if (!annotation.typeName().equals((Object)HttpTypes.HTTP_HEADER_PARAM_ANNOTATION)) continue;
            return (String)annotation.value().orElseThrow();
        }
        throw new CodegenException("Parameter is recognized as @Http.HeaderParam yet it is not annotated: " + parameter.name(), parameter.parameter().originatingElementValue());
    }

    private Constructor.Builder constructor(ClassModel.Builder classModel, ClientEndpoint endpoint) {
        return (Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)Constructor.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(errorHandling -> ((Parameter.Builder)errorHandling.name("errorHandling")).type(RestClientTypes.REST_CLIENT_ERROR_HANDLING))).addParameter(config -> ((Parameter.Builder)config.name("config")).type(DeclarativeTypes.CONFIG))).addParameter(registryClient -> ((Parameter.Builder)registryClient.name("registryClient")).update(it -> this.registryClientParameter((Parameter.Builder)it, endpoint)))).addContentLine("this.errorHandling = errorHandling;")).addContentLine("")).addContent("this.client = registryClient.get().orElseGet(")).addContent(RestClientTypes.WEB_CLIENT)).addContentLine("::create);")).update(it -> this.constructorUriHandling((Constructor.Builder)it, endpoint));
    }

    private void constructorUriHandling(Constructor.Builder ctr, ClientEndpoint endpoint) {
        DelcarativeConfigSupport.assignResolveExpression(ctr, "config", "uri", endpoint.uri());
        String path = endpoint.path().orElse("/");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addContentLine("if (!uri.endsWith(\"/\")) {")).addContentLine("uri = uri + \"/\";")).addContentLine("}")).addContent("this.baseUri = uri");
        if (!path.isBlank()) {
            ((Constructor.Builder)((Constructor.Builder)ctr.addContent(" + \"")).addContent(path)).addContent("\";");
        }
        ctr.addContentLine(";");
    }

    private void registryClientParameter(Parameter.Builder param, ClientEndpoint endpoint) {
        if (endpoint.clientName().isPresent()) {
            param.addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED, (String)((String)endpoint.clientName().get())));
        }
        TypeName optionalWebClient = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(RestClientTypes.WEB_CLIENT)).build();
        param.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.SUPPLIER)).addTypeArgument(optionalWebClient)).build());
    }

    private record NamePart(String name) implements PathParamPart
    {
        @Override
        public String codegen(Map<String, String> pathParamToMethodParam) {
            String methodParameter = pathParamToMethodParam.get(this.name);
            if (methodParameter == null) {
                throw new CodegenException("There is no method parameter defined for path parameter: " + this.name);
            }
            return methodParameter;
        }
    }

    private record StringPart(String value) implements PathParamPart
    {
        @Override
        public String codegen(Map<String, String> pathParamToMethodParam) {
            return "\"" + this.value + "\"";
        }
    }

    private static interface PathParamPart {
        public String codegen(Map<String, String> var1);
    }

    private record MethodOrigin(TypeInfo type, TypedElementInfo method) {
    }

    private record MethodSignature(String name, List<TypeName> parameterTypes) {
        public static MethodSignature create(TypedElementInfo element) {
            return new MethodSignature(element.elementName(), element.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList());
        }
    }
}

