/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.webserver;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.http.HttpFields;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.RestExtensionBase;
import io.helidon.declarative.codegen.http.webserver.ParamCodegenContextImpl;
import io.helidon.declarative.codegen.http.webserver.ParamProviderContext;
import io.helidon.declarative.codegen.http.webserver.ParamProviderHttpEntity;
import io.helidon.declarative.codegen.http.webserver.ParamProviderHttpHeader;
import io.helidon.declarative.codegen.http.webserver.ParamProviderHttpPathParam;
import io.helidon.declarative.codegen.http.webserver.ParamProviderHttpQuery;
import io.helidon.declarative.codegen.http.webserver.ParamProviderHttpReqRes;
import io.helidon.declarative.codegen.http.webserver.ParamProviderSecurityContext;
import io.helidon.declarative.codegen.http.webserver.WebServerCodegenTypes;
import io.helidon.declarative.codegen.http.webserver.spi.HttpParameterCodegenProvider;
import io.helidon.declarative.codegen.model.http.ComputedHeader;
import io.helidon.declarative.codegen.model.http.HeaderValue;
import io.helidon.declarative.codegen.model.http.HttpAnnotated;
import io.helidon.declarative.codegen.model.http.HttpMethod;
import io.helidon.declarative.codegen.model.http.HttpStatus;
import io.helidon.declarative.codegen.model.http.RestEndpoint;
import io.helidon.declarative.codegen.model.http.RestMethod;
import io.helidon.declarative.codegen.model.http.RestMethodParameter;
import io.helidon.declarative.codegen.model.http.ServerEndpoint;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class RestServerExtension
extends RestExtensionBase
implements RegistryCodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(RestServerExtension.class);
    private static final String REQUEST_PARAM_NAME = "helidonDeclarative__server_req";
    private static final String RESPONSE_PARAM_NAME = "helidonDeclarative__server_res";
    private static final String METHOD_RESPONSE_NAME = "helidonDeclarative__response";
    private static final List<HttpParameterCodegenProvider> PARAM_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(HttpParameterCodegenProvider.class)).addService((Object)new ParamProviderHttpEntity()).addService((Object)new ParamProviderHttpHeader()).addService((Object)new ParamProviderHttpPathParam()).addService((Object)new ParamProviderHttpQuery()).addService((Object)new ParamProviderHttpReqRes()).addService((Object)new ParamProviderSecurityContext()).addService((Object)new ParamProviderContext()).build().asList();
    private final RegistryCodegenContext ctx;

    RestServerExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        Collection serverEndpoints = roundContext.annotatedTypes(WebServerCodegenTypes.REST_SERVER_ENDPOINT);
        List endpoints = serverEndpoints.stream().map(this::toEndpoint).collect(Collectors.toUnmodifiableList());
        for (ServerEndpoint endpoint : endpoints) {
            this.process(roundContext, endpoint);
        }
    }

    private static void addSetupMethod(ClassModel.Builder endpointService, String path) {
        endpointService.addMethod(setup -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)setup.accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).name("setup")).addParameter(routing -> ((Parameter.Builder)routing.name("routing")).type(WebServerCodegenTypes.SERVER_HTTP_ROUTING_BUILDER))).addContent("routing.register(\"")).addContent(path)).addContentLine("\", this::routing);"));
    }

    private Constructor.Builder constructor(TypeName endpoint, boolean singleton) {
        Constructor.Builder constructor = Constructor.builder();
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addParameter(param -> param.type(singleton ? endpoint : this.supplierOf(endpoint)).name("endpoint"))).addContentLine("this.endpoint = endpoint;");
        return constructor;
    }

    private void methodHandlers(ClassModel.Builder classModel, Constructor.Builder constructor, TypeName descriptorType, List<RestMethod> methods) {
        constructor.addParameter(httpEntryPoints -> httpEntryPoints.type(WebServerCodegenTypes.DECLARATIVE_ENTRY_POINTS).name("entryPoints"));
        ((Constructor.Builder)((Constructor.Builder)constructor.addContent("var descriptor = ")).addContent(descriptorType)).addContentLine(".INSTANCE;");
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent("var annotations = ")).addContent(descriptorType)).addContentLine(".ANNOTATIONS;")).addContentLine("");
        for (RestMethod method : methods) {
            String uniqueName = method.uniqueName();
            String constant = CodegenUtil.toConstantName((String)("METHOD_" + uniqueName));
            String field = "handler_" + uniqueName;
            classModel.addField(handlerField -> handlerField.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(WebServerCodegenTypes.SERVER_HTTP_HANDLER).name(field));
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent("this.")).addContent(field)).addContentLine(" = entryPoints.handler(")).increaseContentPadding()).increaseContentPadding()).addContentLine("descriptor,")).addContentLine("descriptor.qualifiers(),")).addContentLine("annotations,")).addContent(descriptorType)).addContent(".")).addContent(constant)).addContentLine(",")).addContent("this::")).addContent(method.uniqueName())).addContentLine(");")).decreaseContentPadding()).decreaseContentPadding();
        }
    }

    private void addFields(ClassModel.Builder endpointService, TypeName endpointType, boolean singleton) {
        endpointService.addField(endpointField -> endpointField.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(singleton ? endpointType : this.supplierOf(endpointType)).name("endpoint"));
    }

    private ServerEndpoint toEndpoint(TypeInfo typeInfo) {
        ServerEndpoint.Builder builder = (ServerEndpoint.Builder)ServerEndpoint.builder().type(typeInfo);
        HashSet<Annotation> typeAnnotations = new HashSet<Annotation>(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo));
        builder.annotations(typeAnnotations);
        Annotations.findFirst((TypeName)WebServerCodegenTypes.REST_SERVER_LISTENER, typeAnnotations).flatMap(listener -> listener.stringValue()).ifPresent(arg_0 -> ((ServerEndpoint.Builder)builder).listener(arg_0));
        builder.listenerRequired(true);
        this.path((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.produces((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.consumes((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.headers((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder, WebServerCodegenTypes.REST_SERVER_HEADERS, WebServerCodegenTypes.REST_SERVER_HEADER);
        this.computedHeaders((Set<Annotation>)typeAnnotations, (HttpAnnotated.BuilderBase<?, ?>)builder, WebServerCodegenTypes.REST_SERVER_COMPUTED_HEADERS, WebServerCodegenTypes.REST_SERVER_COMPUTED_HEADER);
        typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).forEach(it -> this.toMethod(typeInfo, builder, (TypedElementInfo)it));
        return builder.build();
    }

    private void toMethod(TypeInfo endpoint, ServerEndpoint.Builder endpointBuilder, TypedElementInfo method) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)endpoint, (TypedElementInfo)method));
        Optional<Annotation> httpMethodAnnotation = this.findMetaAnnotated(HttpTypes.HTTP_METHOD_ANNOTATION, annotations);
        if (httpMethodAnnotation.isEmpty()) {
            return;
        }
        String methodName = method.elementName();
        String uniqueName = this.ctx.uniqueName(endpoint, method);
        RestMethod.Builder builder = (RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)((RestMethod.Builder)RestMethod.builder().returnType(method.typeName())).type(endpoint)).name(methodName)).uniqueName(uniqueName)).method(method)).annotations(annotations)).httpMethod(this.httpMethodFromAnnotation(method, httpMethodAnnotation.get()));
        this.path((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.consumes((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.produces((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder);
        this.headers((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder, WebServerCodegenTypes.REST_SERVER_HEADERS, WebServerCodegenTypes.REST_SERVER_HEADER);
        this.computedHeaders((Set<Annotation>)annotations, (HttpAnnotated.BuilderBase<?, ?>)builder, WebServerCodegenTypes.REST_SERVER_COMPUTED_HEADERS, WebServerCodegenTypes.REST_SERVER_COMPUTED_HEADER);
        if (builder.consumes().isEmpty()) {
            builder.consumes(endpointBuilder.consumes());
        }
        if (builder.produces().isEmpty()) {
            builder.produces(endpointBuilder.produces());
        }
        builder.addHeaders(endpointBuilder.headers());
        builder.addComputedHeaders(endpointBuilder.computedHeaders());
        Annotations.findFirst((TypeName)WebServerCodegenTypes.REST_SERVER_STATUS, annotations).ifPresent(annotation -> {
            int code = annotation.intValue().orElse(200);
            Optional<String> reason = annotation.stringValue("reason").filter(Predicate.not(String::isBlank));
            builder.status(new HttpStatus(code, reason));
        });
        int index = 0;
        for (TypedElementInfo parameterInfo : method.parameterArguments()) {
            this.processEndpointParameter(endpoint, method, parameterInfo, builder, index);
            ++index;
        }
        endpointBuilder.addMethod(builder.build());
    }

    private void processEndpointParameter(TypeInfo typeInfo, TypedElementInfo methodInfo, TypedElementInfo parameterInfo, RestMethod.Builder method, int index) {
        HashSet annotations = new HashSet(TypeHierarchy.hierarchyAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo, (TypedElementInfo)methodInfo, (TypedElementInfo)parameterInfo, (int)index));
        RestMethodParameter parameter = ((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)((RestMethodParameter.Builder)RestMethodParameter.builder().annotations(annotations)).name(parameterInfo.elementName())).typeName(parameterInfo.typeName())).index(index)).method(methodInfo)).type(typeInfo)).parameter(parameterInfo)).build();
        method.addParameter(parameter);
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_HEADER_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addHeaderParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_QUERY_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addQueryParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_PATH_PARAM_ANNOTATION, annotations).isPresent()) {
            method.addPathParameter(parameter);
        }
        if (Annotations.findFirst((TypeName)HttpTypes.HTTP_ENTITY_ANNOTATION, annotations).isPresent()) {
            method.entityParameter(parameter);
        }
    }

    private void process(RegistryRoundContext roundContext, ServerEndpoint endpoint) {
        TypeInfo type = endpoint.type();
        if (type.kind() == ElementKind.INTERFACE) {
            return;
        }
        TypeName endpointTypeName = type.typeName();
        String classNameBase = endpointTypeName.classNameWithEnclosingNames().replace('.', '_');
        String className = classNameBase + "__HttpFeature";
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(endpointTypeName.packageName())).className(className)).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)endpointTypeName, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)endpointTypeName, (TypeName)generatedType, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(generatedType).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addInterface(WebServerCodegenTypes.SERVER_HTTP_FEATURE);
        boolean singleton = type.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON);
        this.addFields(classModel, endpointTypeName, singleton);
        Constructor.Builder constructor = this.constructor(endpointTypeName, singleton);
        FieldHandler fieldHandler = FieldHandler.create((ClassModel.Builder)classModel, (Constructor.Builder)constructor);
        this.methodHandlers(classModel, constructor, this.ctx.descriptorType(type.typeName()), endpoint.methods());
        RestServerExtension.addSetupMethod(classModel, endpoint.path().orElse("/"));
        this.addSocketMethods(classModel, endpoint);
        this.addRoutingMethod(fieldHandler, classModel, endpoint);
        int methodIndex = 0;
        Map<String, String> headerProducerFields = this.headerProducers(fieldHandler, (RestEndpoint)endpoint);
        for (RestMethod restMethod : endpoint.methods()) {
            this.addEndpointMethod(fieldHandler, endpointTypeName, classModel, singleton, restMethod, headerProducerFields, methodIndex);
            ++methodIndex;
        }
        classModel.addConstructor(constructor);
        roundContext.addGeneratedType(generatedType, classModel, endpointTypeName, new Object[]{type.originatingElementValue()});
    }

    private void addSocketMethods(ClassModel.Builder classModel, ServerEndpoint endpoint) {
        Optional listener = endpoint.listener();
        if (listener.isEmpty()) {
            return;
        }
        classModel.addMethod(socket -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)socket.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("socket")).addAnnotation(Annotations.OVERRIDE)).addContent("return \"")).addContent((String)listener.get())).addContentLine("\";"));
        if (endpoint.listenerRequired()) {
            classModel.addMethod(socket -> ((Method.Builder)((Method.Builder)((Method.Builder)socket.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.PRIMITIVE_BOOLEAN).name("socketRequired")).addAnnotation(Annotations.OVERRIDE)).addContentLine("return true;"));
        }
    }

    private void addEndpointMethod(FieldHandler fieldHandler, TypeName endpointTypeName, ClassModel.Builder classModel, boolean singleton, RestMethod restMethod, Map<String, String> headerProducers, int methodIndex) {
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.accessModifier(AccessModifier.PRIVATE)).name(restMethod.uniqueName())).addParameter(req -> req.type(WebServerCodegenTypes.SERVER_REQUEST).name(REQUEST_PARAM_NAME))).addParameter(res -> res.type(WebServerCodegenTypes.SERVER_RESPONSE).name(RESPONSE_PARAM_NAME))).update(it -> restMethod.method().throwsChecked().forEach(checked -> it.addThrows(thrown -> thrown.type(checked))))).update(it -> this.endpointMethodBody(fieldHandler, endpointTypeName, classModel, singleton, (Method.Builder)it, restMethod, headerProducers, methodIndex)));
    }

    private void endpointMethodBody(FieldHandler fieldHandler, TypeName endpointType, ClassModel.Builder classModel, boolean singleton, Method.Builder method, RestMethod restMethod, Map<String, String> headerProducers, int methodIndex) {
        String mediaType;
        for (RestMethodParameter parameter : restMethod.parameters()) {
            String paramName = parameter.name();
            ((Method.Builder)((Method.Builder)method.addContent("var ")).addContent(paramName)).addContent(" = ");
            this.invokeParamHandler(fieldHandler, endpointType, classModel, method, restMethod, parameter, methodIndex);
            method.addContentLine("");
        }
        boolean hasResponse = false;
        if (!restMethod.returnType().boxed().equals((Object)TypeNames.BOXED_VOID)) {
            ((Method.Builder)((Method.Builder)method.addContent("var ")).addContent(METHOD_RESPONSE_NAME)).addContent(" = ");
            hasResponse = true;
        }
        List params = restMethod.parameters();
        if (singleton) {
            method.addContent("this.endpoint.");
        } else {
            method.addContent("this.endpoint.get().");
        }
        ((Method.Builder)method.addContent(restMethod.name())).addContent("(");
        if (params.isEmpty()) {
            method.addContentLine(");");
        } else if (params.size() == 1) {
            ((Method.Builder)method.addContent(((RestMethodParameter)params.getFirst()).name())).addContentLine(");");
        } else {
            ((Method.Builder)((Method.Builder)method.addContentLine("")).increaseContentPadding()).increaseContentPadding();
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                RestMethodParameter next = (RestMethodParameter)iterator.next();
                method.addContent(next.name());
                if (!iterator.hasNext()) continue;
                method.addContentLine(",");
            }
            ((Method.Builder)((Method.Builder)method.addContentLine(");")).decreaseContentPadding()).decreaseContentPadding();
        }
        if (restMethod.produces().size() == 1 && !"*/*".equals(mediaType = (String)restMethod.produces().getFirst())) {
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(RESPONSE_PARAM_NAME)).addContent(".headers().contentType(")).addContent(HttpFields.ensureHttpMediaTypeConstant(fieldHandler, mediaType))).addContentLine(");");
        }
        if (restMethod.status().isPresent()) {
            HttpStatus httpStatus = (HttpStatus)restMethod.status().get();
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(RESPONSE_PARAM_NAME)).addContent(".status(")).addContent(HttpFields.ensureHttpStatusConstant(fieldHandler, httpStatus))).addContentLine(");");
        }
        for (HeaderValue header : restMethod.headers()) {
            ((Method.Builder)((Method.Builder)method.addContent("helidonDeclarative__server_res.header(")).addContent(HttpFields.ensureHeaderValueConstant(fieldHandler, header))).addContentLine(");");
        }
        for (ComputedHeader computedHeader : restMethod.computedHeaders()) {
            String headerNameConstant = HttpFields.ensureHeaderNameConstant(fieldHandler, computedHeader.headerName());
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(headerProducers.get(computedHeader.serviceName()))).addContent(".apply(")).addContent(headerNameConstant)).addContent(").ifPresent(declarative__it -> helidonDeclarative__server_res.header(declarative__it));");
        }
        ((Method.Builder)method.addContent(RESPONSE_PARAM_NAME)).addContent(".send(");
        if (hasResponse) {
            method.addContent(METHOD_RESPONSE_NAME);
        }
        method.addContentLine(");");
    }

    private void invokeParamHandler(FieldHandler fieldHandler, TypeName endpointType, ClassModel.Builder classModel, Method.Builder method, RestMethod restMethod, RestMethodParameter param, int methodIndex) {
        for (HttpParameterCodegenProvider paramProvider : PARAM_PROVIDERS) {
            try {
                if (!paramProvider.codegen(new ParamCodegenContextImpl(fieldHandler, param.annotations(), param.typeName(), classModel, (ContentBuilder<?>)method, REQUEST_PARAM_NAME, RESPONSE_PARAM_NAME, endpointType, restMethod.name(), param.name(), methodIndex, param.index()))) continue;
                return;
            }
            catch (Exception e) {
                throw new CodegenException("Failed to process parameter '" + param.typeName().resolvedName() + " " + param.name() + "' that is " + (param.index() + 1) + " parameter of method " + endpointType.fqName() + "." + restMethod.name() + ", as the parameter handler (" + paramProvider.getClass().getName() + ") threw an exception.", (Throwable)e);
            }
        }
        throw new CodegenException("Failed to process parameter '" + param.typeName().resolvedName() + " " + param.name() + "' that is " + (param.index() + 1) + " parameter of method " + endpointType.fqName() + "." + restMethod.name() + ", as there is no parameter handler registered for it.");
    }

    private void addRoutingMethod(FieldHandler fieldHandler, ClassModel.Builder classModel, ServerEndpoint endpoint) {
        classModel.addMethod(routing -> ((Method.Builder)((Method.Builder)((Method.Builder)routing.accessModifier(AccessModifier.PRIVATE)).name("routing")).addParameter(rules -> rules.type(WebServerCodegenTypes.SERVER_HTTP_RULES).name("rules"))).update(it -> this.routingMethodBody(fieldHandler, (Method.Builder)it, endpoint)));
    }

    private void routingMethodBody(FieldHandler fieldHandler, Method.Builder method, ServerEndpoint endpoint) {
        for (RestMethod restMethod : endpoint.methods()) {
            if (restMethod.produces().isEmpty() && restMethod.consumes().isEmpty()) {
                this.addSimpleRoute(fieldHandler, method, restMethod);
                continue;
            }
            this.addHttpRoute(fieldHandler, method, restMethod);
        }
    }

    private void addSimpleRoute(FieldHandler fieldHandler, Method.Builder routing, RestMethod restMethod) {
        routing.addContent("rules.");
        HttpMethod httpMethod = restMethod.httpMethod();
        if (httpMethod.builtIn()) {
            ((Method.Builder)routing.addContent(httpMethod.name().toLowerCase(Locale.ROOT))).addContent("(");
        } else {
            routing.addContent("route(" + HttpFields.ensureHttpMethodConstant(fieldHandler, httpMethod.name()) + ", ");
        }
        String path = restMethod.path().orElse("/");
        ((Method.Builder)((Method.Builder)routing.addContent("\"")).addContent(path)).addContent("\", ");
        ((Method.Builder)((Method.Builder)routing.addContent("handler_")).addContent(restMethod.uniqueName())).addContentLine(");");
    }

    private void addHttpRoute(FieldHandler fieldHandler, Method.Builder routing, RestMethod restMethod) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)routing.addContent("rules.route(")).addContent(WebServerCodegenTypes.SERVER_HTTP_ROUTE)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".methods(");
        HttpMethod httpMethod = restMethod.httpMethod();
        if (httpMethod.builtIn()) {
            ((Method.Builder)((Method.Builder)routing.addContent(HttpTypes.HTTP_METHOD)).addContent(".")).addContent(httpMethod.name());
        } else {
            routing.addContent(HttpFields.ensureHttpMethodConstant(fieldHandler, httpMethod.name()));
        }
        routing.addContentLine(")");
        boolean consumesExists = !restMethod.consumes().isEmpty();
        routing.addContent(".headers(headers -> ");
        if (consumesExists) {
            routing.addContent("headers.testContentType(");
            routing.addContent(restMethod.consumes().stream().map(it -> HttpFields.ensureHttpMediaTypeConstant(fieldHandler, it)).collect(Collectors.joining(", ")));
            routing.addContent(")");
        }
        if (!restMethod.produces().isEmpty()) {
            if (consumesExists) {
                routing.addContent(" && ");
            }
            routing.addContent("headers.isAccepted(");
            routing.addContent(restMethod.produces().stream().map(it -> HttpFields.ensureHttpMediaTypeConstant(fieldHandler, it)).collect(Collectors.joining(", ")));
            routing.addContent(")");
        }
        routing.addContentLine(")");
        String path = restMethod.path().orElse("/");
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)routing.addContent(".path(\"")).addContent(path)).addContentLine("\")")).addContent(".handler(handler_")).addContent(restMethod.uniqueName())).addContentLine(")");
        ((Method.Builder)((Method.Builder)routing.addContentLine(".build());")).decreaseContentPadding()).decreaseContentPadding();
    }
}

