/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.model.http.HttpAnnotated;
import io.helidon.declarative.codegen.model.http.HttpMethod;
import io.helidon.declarative.codegen.model.http.HttpStatus;
import io.helidon.declarative.codegen.model.http.ModelElement;
import io.helidon.declarative.codegen.model.http.RestMethodBlueprint;
import io.helidon.declarative.codegen.model.http.RestMethodParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.RestMethodBlueprint")
public interface RestMethod
extends RestMethodBlueprint,
Prototype.Api,
HttpAnnotated,
ModelElement {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RestMethod instance) {
        return (Builder)RestMethod.builder().from(instance);
    }

    public static RestMethod create() {
        return RestMethod.builder().buildPrototype();
    }

    @Override
    public Optional<HttpStatus> status();

    @Override
    public TypeName returnType();

    @Override
    public String name();

    @Override
    public String uniqueName();

    @Override
    public HttpMethod httpMethod();

    @Override
    public List<RestMethodParameter> parameters();

    @Override
    public Optional<RestMethodParameter> entityParameter();

    @Override
    public List<RestMethodParameter> headerParameters();

    @Override
    public List<RestMethodParameter> queryParameters();

    @Override
    public List<RestMethodParameter> pathParameters();

    @Override
    public TypedElementInfo method();

    public static class Builder
    extends BuilderBase<Builder, RestMethod>
    implements io.helidon.common.Builder<Builder, RestMethod> {
        private Builder() {
        }

        public RestMethod buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RestMethodImpl(this);
        }

        public RestMethod build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RestMethod>
    extends HttpAnnotated.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<RestMethodParameter> headerParameters = new ArrayList<RestMethodParameter>();
        private final List<RestMethodParameter> parameters = new ArrayList<RestMethodParameter>();
        private final List<RestMethodParameter> pathParameters = new ArrayList<RestMethodParameter>();
        private final List<RestMethodParameter> queryParameters = new ArrayList<RestMethodParameter>();
        private boolean isHeaderParametersMutated;
        private boolean isParametersMutated;
        private boolean isPathParametersMutated;
        private boolean isQueryParametersMutated;
        private HttpMethod httpMethod;
        private HttpStatus status;
        private RestMethodParameter entityParameter;
        private String name;
        private String uniqueName;
        private TypedElementInfo method;
        private TypeName returnType;

        protected BuilderBase() {
        }

        public BUILDER from(RestMethod prototype) {
            super.from(prototype);
            this.status(prototype.status());
            this.returnType(prototype.returnType());
            this.name(prototype.name());
            this.uniqueName(prototype.uniqueName());
            this.httpMethod(prototype.httpMethod());
            if (!this.isParametersMutated) {
                this.parameters.clear();
            }
            this.addParameters(prototype.parameters());
            this.entityParameter(prototype.entityParameter());
            if (!this.isHeaderParametersMutated) {
                this.headerParameters.clear();
            }
            this.addHeaderParameters(prototype.headerParameters());
            if (!this.isQueryParametersMutated) {
                this.queryParameters.clear();
            }
            this.addQueryParameters(prototype.queryParameters());
            if (!this.isPathParametersMutated) {
                this.pathParameters.clear();
            }
            this.addPathParameters(prototype.pathParameters());
            this.method(prototype.method());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from((HttpAnnotated.BuilderBase<?, ?>)builder);
            builder.status().ifPresent(this::status);
            builder.returnType().ifPresent(this::returnType);
            builder.name().ifPresent(this::name);
            builder.uniqueName().ifPresent(this::uniqueName);
            builder.httpMethod().ifPresent(this::httpMethod);
            if (this.isParametersMutated) {
                if (builder.isParametersMutated) {
                    this.addParameters(builder.parameters);
                }
            } else {
                this.parameters.clear();
                this.addParameters(builder.parameters);
            }
            builder.entityParameter().ifPresent(this::entityParameter);
            if (this.isHeaderParametersMutated) {
                if (builder.isHeaderParametersMutated) {
                    this.addHeaderParameters(builder.headerParameters);
                }
            } else {
                this.headerParameters.clear();
                this.addHeaderParameters(builder.headerParameters);
            }
            if (this.isQueryParametersMutated) {
                if (builder.isQueryParametersMutated) {
                    this.addQueryParameters(builder.queryParameters);
                }
            } else {
                this.queryParameters.clear();
                this.addQueryParameters(builder.queryParameters);
            }
            if (this.isPathParametersMutated) {
                if (builder.isPathParametersMutated) {
                    this.addPathParameters(builder.pathParameters);
                }
            } else {
                this.pathParameters.clear();
                this.addPathParameters(builder.pathParameters);
            }
            builder.method().ifPresent(this::method);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStatus() {
            this.status = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER status(HttpStatus status) {
            Objects.requireNonNull(status);
            this.status = status;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(TypeName returnType) {
            Objects.requireNonNull(returnType);
            this.returnType = returnType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.returnType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.returnType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER uniqueName(String uniqueName) {
            Objects.requireNonNull(uniqueName);
            this.uniqueName = uniqueName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER httpMethod(HttpMethod httpMethod) {
            Objects.requireNonNull(httpMethod);
            this.httpMethod = httpMethod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameters(List<? extends RestMethodParameter> parameters) {
            Objects.requireNonNull(parameters);
            this.isParametersMutated = true;
            this.parameters.clear();
            this.parameters.addAll(parameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameters(List<? extends RestMethodParameter> parameters) {
            Objects.requireNonNull(parameters);
            this.isParametersMutated = true;
            this.parameters.addAll(parameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameter(RestMethodParameter parameter) {
            Objects.requireNonNull(parameter);
            this.parameters.add(parameter);
            this.isParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameter(Consumer<RestMethodParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethodParameter.Builder builder = RestMethodParameter.builder();
            consumer.accept(builder);
            this.parameters.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearEntityParameter() {
            this.entityParameter = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER entityParameter(RestMethodParameter entityParameter) {
            Objects.requireNonNull(entityParameter);
            this.entityParameter = entityParameter;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER entityParameter(Consumer<RestMethodParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethodParameter.Builder builder = RestMethodParameter.builder();
            consumer.accept(builder);
            this.entityParameter(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER headerParameters(List<? extends RestMethodParameter> headerParameters) {
            Objects.requireNonNull(headerParameters);
            this.isHeaderParametersMutated = true;
            this.headerParameters.clear();
            this.headerParameters.addAll(headerParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeaderParameters(List<? extends RestMethodParameter> headerParameters) {
            Objects.requireNonNull(headerParameters);
            this.isHeaderParametersMutated = true;
            this.headerParameters.addAll(headerParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeaderParameter(RestMethodParameter headerParameter) {
            Objects.requireNonNull(headerParameter);
            this.headerParameters.add(headerParameter);
            this.isHeaderParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeaderParameter(Consumer<RestMethodParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethodParameter.Builder builder = RestMethodParameter.builder();
            consumer.accept(builder);
            this.headerParameters.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queryParameters(List<? extends RestMethodParameter> queryParameters) {
            Objects.requireNonNull(queryParameters);
            this.isQueryParametersMutated = true;
            this.queryParameters.clear();
            this.queryParameters.addAll(queryParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueryParameters(List<? extends RestMethodParameter> queryParameters) {
            Objects.requireNonNull(queryParameters);
            this.isQueryParametersMutated = true;
            this.queryParameters.addAll(queryParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueryParameter(RestMethodParameter queryParameter) {
            Objects.requireNonNull(queryParameter);
            this.queryParameters.add(queryParameter);
            this.isQueryParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueryParameter(Consumer<RestMethodParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethodParameter.Builder builder = RestMethodParameter.builder();
            consumer.accept(builder);
            this.queryParameters.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pathParameters(List<? extends RestMethodParameter> pathParameters) {
            Objects.requireNonNull(pathParameters);
            this.isPathParametersMutated = true;
            this.pathParameters.clear();
            this.pathParameters.addAll(pathParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPathParameters(List<? extends RestMethodParameter> pathParameters) {
            Objects.requireNonNull(pathParameters);
            this.isPathParametersMutated = true;
            this.pathParameters.addAll(pathParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPathParameter(RestMethodParameter pathParameter) {
            Objects.requireNonNull(pathParameter);
            this.pathParameters.add(pathParameter);
            this.isPathParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPathParameter(Consumer<RestMethodParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethodParameter.Builder builder = RestMethodParameter.builder();
            consumer.accept(builder);
            this.pathParameters.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(TypedElementInfo method) {
            Objects.requireNonNull(method);
            this.method = method;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.method(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.method(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<HttpStatus> status() {
            return Optional.ofNullable(this.status);
        }

        public Optional<TypeName> returnType() {
            return Optional.ofNullable(this.returnType);
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> uniqueName() {
            return Optional.ofNullable(this.uniqueName);
        }

        public Optional<HttpMethod> httpMethod() {
            return Optional.ofNullable(this.httpMethod);
        }

        public List<RestMethodParameter> parameters() {
            return this.parameters;
        }

        public Optional<RestMethodParameter> entityParameter() {
            return Optional.ofNullable(this.entityParameter);
        }

        public List<RestMethodParameter> headerParameters() {
            return this.headerParameters;
        }

        public List<RestMethodParameter> queryParameters() {
            return this.queryParameters;
        }

        public List<RestMethodParameter> pathParameters() {
            return this.pathParameters;
        }

        public Optional<TypedElementInfo> method() {
            return Optional.ofNullable(this.method);
        }

        @Override
        public String toString() {
            return "RestMethodBuilder{status=" + String.valueOf(this.status) + ",returnType=" + String.valueOf(this.returnType) + ",name=" + this.name + ",uniqueName=" + this.uniqueName + ",httpMethod=" + String.valueOf(this.httpMethod) + ",parameters=" + String.valueOf(this.parameters) + ",entityParameter=" + String.valueOf(this.entityParameter) + ",headerParameters=" + String.valueOf(this.headerParameters) + ",queryParameters=" + String.valueOf(this.queryParameters) + ",pathParameters=" + String.valueOf(this.pathParameters) + ",method=" + String.valueOf(this.method) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.returnType == null) {
                collector.fatal(this.getClass(), "Property \"returnType\" must not be null, but not set");
            }
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.uniqueName == null) {
                collector.fatal(this.getClass(), "Property \"uniqueName\" must not be null, but not set");
            }
            if (this.httpMethod == null) {
                collector.fatal(this.getClass(), "Property \"httpMethod\" must not be null, but not set");
            }
            if (this.method == null) {
                collector.fatal(this.getClass(), "Property \"method\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER status(Optional<? extends HttpStatus> status) {
            Objects.requireNonNull(status);
            this.status = status.map(HttpStatus.class::cast).orElse(this.status);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER entityParameter(Optional<? extends RestMethodParameter> entityParameter) {
            Objects.requireNonNull(entityParameter);
            this.entityParameter = entityParameter.map(RestMethodParameter.class::cast).orElse(this.entityParameter);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class RestMethodImpl
        extends HttpAnnotated.BuilderBase.HttpAnnotatedImpl
        implements RestMethod {
            private final HttpMethod httpMethod;
            private final List<RestMethodParameter> headerParameters;
            private final List<RestMethodParameter> parameters;
            private final List<RestMethodParameter> pathParameters;
            private final List<RestMethodParameter> queryParameters;
            private final Optional<RestMethodParameter> entityParameter;
            private final Optional<HttpStatus> status;
            private final String name;
            private final String uniqueName;
            private final TypedElementInfo method;
            private final TypeName returnType;

            protected RestMethodImpl(BuilderBase<?, ?> builder) {
                super((HttpAnnotated.BuilderBase<?, ?>)builder);
                this.status = builder.status().map(Function.identity());
                this.returnType = builder.returnType().get();
                this.name = builder.name().get();
                this.uniqueName = builder.uniqueName().get();
                this.httpMethod = builder.httpMethod().get();
                this.parameters = List.copyOf(builder.parameters());
                this.entityParameter = builder.entityParameter().map(Function.identity());
                this.headerParameters = List.copyOf(builder.headerParameters());
                this.queryParameters = List.copyOf(builder.queryParameters());
                this.pathParameters = List.copyOf(builder.pathParameters());
                this.method = builder.method().get();
            }

            @Override
            public Optional<HttpStatus> status() {
                return this.status;
            }

            @Override
            public TypeName returnType() {
                return this.returnType;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String uniqueName() {
                return this.uniqueName;
            }

            @Override
            public HttpMethod httpMethod() {
                return this.httpMethod;
            }

            @Override
            public List<RestMethodParameter> parameters() {
                return this.parameters;
            }

            @Override
            public Optional<RestMethodParameter> entityParameter() {
                return this.entityParameter;
            }

            @Override
            public List<RestMethodParameter> headerParameters() {
                return this.headerParameters;
            }

            @Override
            public List<RestMethodParameter> queryParameters() {
                return this.queryParameters;
            }

            @Override
            public List<RestMethodParameter> pathParameters() {
                return this.pathParameters;
            }

            @Override
            public TypedElementInfo method() {
                return this.method;
            }

            @Override
            public String toString() {
                return "RestMethod{status=" + String.valueOf(this.status) + ",returnType=" + String.valueOf(this.returnType) + ",name=" + this.name + ",uniqueName=" + this.uniqueName + ",httpMethod=" + String.valueOf(this.httpMethod) + ",parameters=" + String.valueOf(this.parameters) + ",entityParameter=" + String.valueOf(this.entityParameter) + ",headerParameters=" + String.valueOf(this.headerParameters) + ",queryParameters=" + String.valueOf(this.queryParameters) + ",pathParameters=" + String.valueOf(this.pathParameters) + ",method=" + String.valueOf(this.method) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RestMethod)) {
                    return false;
                }
                RestMethod other = (RestMethod)o;
                return super.equals(other) && Objects.equals(this.status, other.status()) && Objects.equals(this.returnType, other.returnType()) && Objects.equals(this.name, other.name()) && Objects.equals(this.uniqueName, other.uniqueName()) && Objects.equals(this.httpMethod, other.httpMethod()) && Objects.equals(this.parameters, other.parameters()) && Objects.equals(this.entityParameter, other.entityParameter()) && Objects.equals(this.headerParameters, other.headerParameters()) && Objects.equals(this.queryParameters, other.queryParameters()) && Objects.equals(this.pathParameters, other.pathParameters()) && Objects.equals(this.method, other.method());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.status, this.returnType, this.name, this.uniqueName, this.httpMethod, this.parameters, this.entityParameter, this.headerParameters, this.queryParameters, this.pathParameters, this.method);
            }
        }
    }
}

