/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.model.http.ModelElement;
import io.helidon.declarative.codegen.model.http.RestMethodParameterBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.RestMethodParameterBlueprint")
public interface RestMethodParameter
extends RestMethodParameterBlueprint,
Prototype.Api,
ModelElement {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RestMethodParameter instance) {
        return (Builder)RestMethodParameter.builder().from(instance);
    }

    public static RestMethodParameter create() {
        return RestMethodParameter.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, RestMethodParameter>
    implements io.helidon.common.Builder<Builder, RestMethodParameter> {
        private Builder() {
        }

        public RestMethodParameter buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RestMethodParameterImpl(this);
        }

        public RestMethodParameter build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RestMethodParameter>
    extends ModelElement.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private int index;
        private String name;
        private TypedElementInfo method;
        private TypedElementInfo parameter;
        private TypeName typeName;

        protected BuilderBase() {
        }

        public BUILDER from(RestMethodParameter prototype) {
            super.from(prototype);
            this.name(prototype.name());
            this.typeName(prototype.typeName());
            this.index(prototype.index());
            this.method(prototype.method());
            this.parameter(prototype.parameter());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.name().ifPresent(this::name);
            builder.typeName().ifPresent(this::typeName);
            this.index(builder.index());
            builder.method().ifPresent(this::method);
            builder.parameter().ifPresent(this::parameter);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(TypeName typeName) {
            Objects.requireNonNull(typeName);
            this.typeName = typeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.typeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER index(int index) {
            this.index = index;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(TypedElementInfo method) {
            Objects.requireNonNull(method);
            this.method = method;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.method(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.method(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameter(TypedElementInfo parameter) {
            Objects.requireNonNull(parameter);
            this.parameter = parameter;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameter(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.parameter(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameter(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.parameter(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<TypeName> typeName() {
            return Optional.ofNullable(this.typeName);
        }

        public int index() {
            return this.index;
        }

        public Optional<TypedElementInfo> method() {
            return Optional.ofNullable(this.method);
        }

        public Optional<TypedElementInfo> parameter() {
            return Optional.ofNullable(this.parameter);
        }

        @Override
        public String toString() {
            return "RestMethodParameterBuilder{name=" + this.name + ",typeName=" + String.valueOf(this.typeName) + ",index=" + this.index + ",method=" + String.valueOf(this.method) + ",parameter=" + String.valueOf(this.parameter) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.typeName == null) {
                collector.fatal(this.getClass(), "Property \"typeName\" must not be null, but not set");
            }
            if (this.method == null) {
                collector.fatal(this.getClass(), "Property \"method\" must not be null, but not set");
            }
            if (this.parameter == null) {
                collector.fatal(this.getClass(), "Property \"parameter\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class RestMethodParameterImpl
        extends ModelElement.BuilderBase.ModelElementImpl
        implements RestMethodParameter {
            private final int index;
            private final String name;
            private final TypedElementInfo method;
            private final TypedElementInfo parameter;
            private final TypeName typeName;

            protected RestMethodParameterImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.name = builder.name().get();
                this.typeName = builder.typeName().get();
                this.index = builder.index();
                this.method = builder.method().get();
                this.parameter = builder.parameter().get();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public TypeName typeName() {
                return this.typeName;
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public TypedElementInfo method() {
                return this.method;
            }

            @Override
            public TypedElementInfo parameter() {
                return this.parameter;
            }

            @Override
            public String toString() {
                return "RestMethodParameter{name=" + this.name + ",typeName=" + String.valueOf(this.typeName) + ",index=" + this.index + ",method=" + String.valueOf(this.method) + ",parameter=" + String.valueOf(this.parameter) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RestMethodParameter)) {
                    return false;
                }
                RestMethodParameter other = (RestMethodParameter)o;
                return super.equals(other) && Objects.equals(this.name, other.name()) && Objects.equals(this.typeName, other.typeName()) && this.index == other.index() && Objects.equals(this.method, other.method()) && Objects.equals(this.parameter, other.parameter());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.name, this.typeName, this.index, this.method, this.parameter);
            }
        }
    }
}

