/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.declarative.codegen.model.http.ComputedHeader;
import io.helidon.declarative.codegen.model.http.HeaderValue;
import io.helidon.declarative.codegen.model.http.HttpAnnotatedBlueprint;
import io.helidon.declarative.codegen.model.http.ModelElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.HttpAnnotatedBlueprint")
public interface HttpAnnotated
extends HttpAnnotatedBlueprint,
Prototype.Api,
ModelElement {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpAnnotated instance) {
        return (Builder)HttpAnnotated.builder().from(instance);
    }

    public static class Builder
    extends BuilderBase<Builder, HttpAnnotated>
    implements io.helidon.common.Builder<Builder, HttpAnnotated> {
        private Builder() {
        }

        public HttpAnnotated buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.HttpAnnotatedImpl(this);
        }

        public HttpAnnotated build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends HttpAnnotated>
    extends ModelElement.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<ComputedHeader> computedHeaders = new ArrayList<ComputedHeader>();
        private final List<HeaderValue> headers = new ArrayList<HeaderValue>();
        private final List<String> consumes = new ArrayList<String>();
        private final List<String> produces = new ArrayList<String>();
        private boolean isComputedHeadersMutated;
        private boolean isConsumesMutated;
        private boolean isHeadersMutated;
        private boolean isProducesMutated;
        private String path;

        protected BuilderBase() {
        }

        public BUILDER from(HttpAnnotated prototype) {
            super.from(prototype);
            if (!this.isProducesMutated) {
                this.produces.clear();
            }
            this.addProduces(prototype.produces());
            if (!this.isConsumesMutated) {
                this.consumes.clear();
            }
            this.addConsumes(prototype.consumes());
            if (!this.isHeadersMutated) {
                this.headers.clear();
            }
            this.addHeaders(prototype.headers());
            if (!this.isComputedHeadersMutated) {
                this.computedHeaders.clear();
            }
            this.addComputedHeaders(prototype.computedHeaders());
            this.path(prototype.path());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            if (this.isProducesMutated) {
                if (builder.isProducesMutated) {
                    this.addProduces(builder.produces);
                }
            } else {
                this.produces.clear();
                this.addProduces(builder.produces);
            }
            if (this.isConsumesMutated) {
                if (builder.isConsumesMutated) {
                    this.addConsumes(builder.consumes);
                }
            } else {
                this.consumes.clear();
                this.addConsumes(builder.consumes);
            }
            if (this.isHeadersMutated) {
                if (builder.isHeadersMutated) {
                    this.addHeaders(builder.headers);
                }
            } else {
                this.headers.clear();
                this.addHeaders(builder.headers);
            }
            if (this.isComputedHeadersMutated) {
                if (builder.isComputedHeadersMutated) {
                    this.addComputedHeaders(builder.computedHeaders);
                }
            } else {
                this.computedHeaders.clear();
                this.addComputedHeaders(builder.computedHeaders);
            }
            builder.path().ifPresent(this::path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER produces(List<String> produces) {
            Objects.requireNonNull(produces);
            this.isProducesMutated = true;
            this.produces.clear();
            this.produces.addAll(produces);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProduces(List<String> produces) {
            Objects.requireNonNull(produces);
            this.isProducesMutated = true;
            this.produces.addAll(produces);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProduce(String produce) {
            Objects.requireNonNull(produce);
            this.produces.add(produce);
            this.isProducesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER consumes(List<String> consumes) {
            Objects.requireNonNull(consumes);
            this.isConsumesMutated = true;
            this.consumes.clear();
            this.consumes.addAll(consumes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConsumes(List<String> consumes) {
            Objects.requireNonNull(consumes);
            this.isConsumesMutated = true;
            this.consumes.addAll(consumes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConsume(String consume) {
            Objects.requireNonNull(consume);
            this.consumes.add(consume);
            this.isConsumesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER headers(List<? extends HeaderValue> headers) {
            Objects.requireNonNull(headers);
            this.isHeadersMutated = true;
            this.headers.clear();
            this.headers.addAll(headers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeaders(List<? extends HeaderValue> headers) {
            Objects.requireNonNull(headers);
            this.isHeadersMutated = true;
            this.headers.addAll(headers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(HeaderValue header) {
            Objects.requireNonNull(header);
            this.headers.add(header);
            this.isHeadersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER computedHeaders(List<? extends ComputedHeader> computedHeaders) {
            Objects.requireNonNull(computedHeaders);
            this.isComputedHeadersMutated = true;
            this.computedHeaders.clear();
            this.computedHeaders.addAll(computedHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addComputedHeaders(List<? extends ComputedHeader> computedHeaders) {
            Objects.requireNonNull(computedHeaders);
            this.isComputedHeadersMutated = true;
            this.computedHeaders.addAll(computedHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addComputedHeader(ComputedHeader computedHeader) {
            Objects.requireNonNull(computedHeader);
            this.computedHeaders.add(computedHeader);
            this.isComputedHeadersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPath() {
            this.path = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(String path) {
            Objects.requireNonNull(path);
            this.path = path;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<String> produces() {
            return this.produces;
        }

        public List<String> consumes() {
            return this.consumes;
        }

        public List<HeaderValue> headers() {
            return this.headers;
        }

        public List<ComputedHeader> computedHeaders() {
            return this.computedHeaders;
        }

        public Optional<String> path() {
            return Optional.ofNullable(this.path);
        }

        @Override
        public String toString() {
            return "HttpAnnotatedBuilder{produces=" + String.valueOf(this.produces) + ",consumes=" + String.valueOf(this.consumes) + ",headers=" + String.valueOf(this.headers) + ",computedHeaders=" + String.valueOf(this.computedHeaders) + ",path=" + this.path + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER path(Optional<String> path) {
            Objects.requireNonNull(path);
            this.path = path.map(String.class::cast).orElse(this.path);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class HttpAnnotatedImpl
        extends ModelElement.BuilderBase.ModelElementImpl
        implements HttpAnnotated {
            private final List<ComputedHeader> computedHeaders;
            private final List<HeaderValue> headers;
            private final List<String> consumes;
            private final List<String> produces;
            private final Optional<String> path;

            protected HttpAnnotatedImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.produces = List.copyOf(builder.produces());
                this.consumes = List.copyOf(builder.consumes());
                this.headers = List.copyOf(builder.headers());
                this.computedHeaders = List.copyOf(builder.computedHeaders());
                this.path = builder.path();
            }

            @Override
            public List<String> produces() {
                return this.produces;
            }

            @Override
            public List<String> consumes() {
                return this.consumes;
            }

            @Override
            public List<HeaderValue> headers() {
                return this.headers;
            }

            @Override
            public List<ComputedHeader> computedHeaders() {
                return this.computedHeaders;
            }

            @Override
            public Optional<String> path() {
                return this.path;
            }

            @Override
            public String toString() {
                return "HttpAnnotated{produces=" + String.valueOf(this.produces) + ",consumes=" + String.valueOf(this.consumes) + ",headers=" + String.valueOf(this.headers) + ",computedHeaders=" + String.valueOf(this.computedHeaders) + ",path=" + String.valueOf(this.path) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HttpAnnotated)) {
                    return false;
                }
                HttpAnnotated other = (HttpAnnotated)o;
                return super.equals(other) && Objects.equals(this.produces, other.produces()) && Objects.equals(this.consumes, other.consumes()) && Objects.equals(this.headers, other.headers()) && Objects.equals(this.computedHeaders, other.computedHeaders()) && Objects.equals(this.path, other.path());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.produces, this.consumes, this.headers, this.computedHeaders, this.path);
            }
        }
    }
}

