/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatements;
import java.util.List;

public class DbClientContext
implements DbContext {
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;
    private final List<DbClientService> clientServices;
    private final boolean missingMapParametersAsNull;
    private final DbStatements statements;
    private final String dbType;

    protected DbClientContext(BuilderBase<? extends BuilderBase<?, ? extends DbClientContext>, ? extends DbClientContext> builder) {
        this.dbMapperManager = builder.dbMapperManager;
        this.mapperManager = builder.mapperManager;
        this.clientServices = builder.clientServices;
        this.missingMapParametersAsNull = builder.missingMapParametersAsNull;
        this.statements = builder.statements;
        this.dbType = builder.dbType;
    }

    @Override
    public boolean missingMapParametersAsNull() {
        return this.missingMapParametersAsNull;
    }

    @Override
    public DbStatements statements() {
        return this.statements;
    }

    @Override
    public DbMapperManager dbMapperManager() {
        return this.dbMapperManager;
    }

    @Override
    public MapperManager mapperManager() {
        return this.mapperManager;
    }

    @Override
    public List<DbClientService> clientServices() {
        return this.clientServices;
    }

    @Override
    public String dbType() {
        return this.dbType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static abstract class BuilderBase<B extends BuilderBase<B, T>, T extends DbClientContext>
    implements io.helidon.common.Builder<B, T> {
        private DbMapperManager dbMapperManager;
        private MapperManager mapperManager;
        private List<DbClientService> clientServices = List.of();
        private boolean missingMapParametersAsNull;
        private DbStatements statements;
        private String dbType;

        protected BuilderBase() {
        }

        public B dbMapperManager(DbMapperManager dbMapperManager) {
            this.dbMapperManager = dbMapperManager;
            return (B)((BuilderBase)this.identity());
        }

        public B mapperManager(MapperManager mapperManager) {
            this.mapperManager = mapperManager;
            return (B)((BuilderBase)this.identity());
        }

        public B clientServices(List<DbClientService> clientServices) {
            this.clientServices = clientServices;
            return (B)((BuilderBase)this.identity());
        }

        public B missingMapParametersAsNull(boolean missingMapParametersAsNull) {
            this.missingMapParametersAsNull = missingMapParametersAsNull;
            return (B)((BuilderBase)this.identity());
        }

        public B statements(DbStatements statements) {
            this.statements = statements;
            return (B)((BuilderBase)this.identity());
        }

        public B dbType(String dbType) {
            this.dbType = dbType;
            return (B)((BuilderBase)this.identity());
        }
    }

    public static final class Builder
    extends BuilderBase<Builder, DbClientContext> {
        public DbClientContext build() {
            return new DbClientContext(this);
        }
    }
}

