/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.AutoClosingDoubleStream;
import io.helidon.dbclient.AutoClosingHandler;
import io.helidon.dbclient.AutoClosingLongStream;
import io.helidon.dbclient.AutoClosingStream;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

class AutoClosingIntStream
implements IntStream {
    private final IntStream delegate;
    private final Runnable closeHandler;

    private AutoClosingIntStream(IntStream delegate, Runnable closeHandler) {
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    static IntStream decorate(IntStream stream, Runnable closeHandler) {
        if (stream instanceof AutoClosingIntStream) {
            return stream;
        }
        return new AutoClosingIntStream(stream, AutoClosingHandler.decorate(closeHandler));
    }

    @Override
    public void forEach(IntConsumer action) {
        try {
            this.delegate.forEach(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        try {
            this.delegate.forEachOrdered(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public int[] toArray() {
        try {
            int[] nArray = this.delegate.toArray();
            return nArray;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        try {
            int n = this.delegate.reduce(identity, op);
            return n;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        try {
            OptionalInt optionalInt = this.delegate.reduce(op);
            return optionalInt;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try {
            R r = this.delegate.collect(supplier, accumulator, combiner);
            return r;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public int sum() {
        try {
            int n = this.delegate.sum();
            return n;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalInt min() {
        try {
            OptionalInt optionalInt = this.delegate.min();
            return optionalInt;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalInt max() {
        try {
            OptionalInt optionalInt = this.delegate.max();
            return optionalInt;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long count() {
        try {
            long l = this.delegate.count();
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble average() {
        try {
            OptionalDouble optionalDouble = this.delegate.average();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        try {
            IntSummaryStatistics intSummaryStatistics = this.delegate.summaryStatistics();
            return intSummaryStatistics;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        try {
            boolean bl = this.delegate.anyMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        try {
            boolean bl = this.delegate.allMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        try {
            boolean bl = this.delegate.noneMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalInt findFirst() {
        try {
            OptionalInt optionalInt = this.delegate.findFirst();
            return optionalInt;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalInt findAny() {
        try {
            OptionalInt optionalInt = this.delegate.findAny();
            return optionalInt;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        try {
            IntStream intStream = AutoClosingIntStream.decorate(this.delegate.filter(predicate), this.closeHandler);
            return intStream;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        try {
            IntStream intStream = AutoClosingIntStream.decorate(this.delegate.map(mapper), this.closeHandler);
            return intStream;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        return AutoClosingStream.decorate(this.delegate.mapToObj(mapper), this.closeHandler);
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        return AutoClosingLongStream.decorate(this.delegate.mapToLong(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.mapToDouble(mapper), this.closeHandler);
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        return AutoClosingIntStream.decorate(this.delegate.flatMap(mapper), this.closeHandler);
    }

    @Override
    public IntStream mapMulti(IntStream.IntMapMultiConsumer mapper) {
        return AutoClosingIntStream.decorate(this.delegate.mapMulti(mapper), this.closeHandler);
    }

    @Override
    public IntStream distinct() {
        return AutoClosingIntStream.decorate(this.delegate.distinct(), this.closeHandler);
    }

    @Override
    public IntStream sorted() {
        return AutoClosingIntStream.decorate(this.delegate.sorted(), this.closeHandler);
    }

    @Override
    public IntStream peek(IntConsumer action) {
        return AutoClosingIntStream.decorate(this.delegate.peek(action), this.closeHandler);
    }

    @Override
    public IntStream limit(long maxSize) {
        return AutoClosingIntStream.decorate(this.delegate.limit(maxSize), this.closeHandler);
    }

    @Override
    public IntStream skip(long n) {
        return AutoClosingIntStream.decorate(this.delegate.skip(n), this.closeHandler);
    }

    @Override
    public IntStream takeWhile(IntPredicate predicate) {
        return AutoClosingIntStream.decorate(this.delegate.takeWhile(predicate), this.closeHandler);
    }

    @Override
    public IntStream dropWhile(IntPredicate predicate) {
        return AutoClosingIntStream.decorate(this.delegate.dropWhile(predicate), this.closeHandler);
    }

    @Override
    public LongStream asLongStream() {
        return AutoClosingLongStream.decorate(this.delegate.asLongStream(), this.closeHandler);
    }

    @Override
    public DoubleStream asDoubleStream() {
        return AutoClosingDoubleStream.decorate(this.delegate.asDoubleStream(), this.closeHandler);
    }

    @Override
    public Stream<Integer> boxed() {
        return AutoClosingStream.decorate(this.delegate.boxed(), this.closeHandler);
    }

    @Override
    public IntStream sequential() {
        return AutoClosingIntStream.decorate(this.delegate.sequential(), this.closeHandler);
    }

    @Override
    public IntStream parallel() {
        return AutoClosingIntStream.decorate(this.delegate.parallel(), this.closeHandler);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        final PrimitiveIterator.OfInt iterator = this.delegate.iterator();
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    return true;
                }
                AutoClosingIntStream.this.closeHandler.run();
                return false;
            }

            @Override
            public int nextInt() {
                return iterator.nextInt();
            }
        };
    }

    @Override
    public Spliterator.OfInt spliterator() {
        final Spliterator.OfInt spliterator = this.delegate.spliterator();
        return new Spliterator.OfInt(){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (spliterator.tryAdvance(action)) {
                    return true;
                }
                AutoClosingIntStream.this.closeHandler.run();
                return false;
            }

            @Override
            public Spliterator.OfInt trySplit() {
                return spliterator.trySplit();
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics();
            }
        };
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public IntStream unordered() {
        return AutoClosingIntStream.decorate((IntStream)this.delegate.unordered(), this.closeHandler);
    }

    @Override
    public IntStream onClose(Runnable closeHandler) {
        return AutoClosingIntStream.decorate((IntStream)this.delegate.onClose(closeHandler), this.closeHandler);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

