/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.config.Config;
import io.helidon.dbclient.DbClientException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@FunctionalInterface
public interface DbStatements {
    public String statement(String var1) throws DbClientException;

    public static Builder builder() {
        return new Builder();
    }

    public static DbStatements create(Config config) {
        return DbStatements.builder().config(config).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, DbStatements> {
        private final Map<String, String> configuredStatements = new HashMap<String, String>();

        public Builder addStatement(String name, String statement) {
            Objects.requireNonNull(name, "Statement name must be provided");
            Objects.requireNonNull(statement, "Statement body must be provided");
            this.configuredStatements.put(name, statement);
            return this;
        }

        public Builder config(Config config) {
            config.detach().asMap().ifPresent(this.configuredStatements::putAll);
            return this;
        }

        public DbStatements build() {
            return new DbStatements(){
                private final Map<String, String> statements;
                {
                    this.statements = new HashMap<String, String>(configuredStatements);
                }

                @Override
                public String statement(String name) {
                    String statement = this.statements.get(name);
                    if (null == statement) {
                        throw new DbClientException("Statement named '" + name + "' is not defined");
                    }
                    return statement;
                }
            };
        }
    }
}

