/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.dbclient.DbMapperManagerImpl;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public interface DbMapperManager {
    public static final GenericType<DbRow> TYPE_DB_ROW = GenericType.create(DbRow.class);
    public static final GenericType<Map<String, ?>> TYPE_NAMED_PARAMS = new GenericType<Map<String, ?>>(){};
    public static final GenericType<List<?>> TYPE_INDEXED_PARAMS = new GenericType<List<?>>(){};

    public static Builder builder() {
        return new Builder();
    }

    public static DbMapperManager create() {
        return DbMapperManager.builder().build();
    }

    public static DbMapperManager create(HelidonServiceLoader<DbMapperProvider> serviceLoader) {
        return DbMapperManager.builder().serviceLoader(serviceLoader).build();
    }

    public <T> T read(DbRow var1, Class<T> var2) throws MapperException;

    public <T> T read(DbRow var1, GenericType<T> var2) throws MapperException;

    public <T> Map<String, ?> toNamedParameters(T var1, Class<T> var2);

    public <T> List<?> toIndexedParameters(T var1, Class<T> var2);

    public static final class Builder
    implements io.helidon.common.Builder<DbMapperManager> {
        private final HelidonServiceLoader.Builder<DbMapperProvider> providers = HelidonServiceLoader.builder(ServiceLoader.load(DbMapperProvider.class));
        private HelidonServiceLoader<DbMapperProvider> providerLoader;

        private Builder() {
        }

        public DbMapperManager build() {
            return new DbMapperManagerImpl(this);
        }

        public Builder addMapperProvider(DbMapperProvider provider) {
            this.providers.addService((Object)provider);
            return this;
        }

        public Builder addMapperProvider(DbMapperProvider provider, int priority) {
            this.providers.addService((Object)provider, priority);
            return this;
        }

        List<DbMapperProvider> mapperProviders() {
            if (null == this.providerLoader) {
                return this.providers.build().asList();
            }
            return this.providerLoader.asList();
        }

        private Builder serviceLoader(HelidonServiceLoader<DbMapperProvider> serviceLoader) {
            this.providerLoader = serviceLoader;
            return this;
        }
    }
}

