/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.MongoDatabase;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbIndexedStatementParameters;
import io.helidon.dbclient.DbNamedStatementParameters;
import io.helidon.dbclient.DbStatement;
import io.helidon.dbclient.DbStatementBase;
import io.helidon.dbclient.DbStatementParameters;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.StatementParsers;
import jakarta.json.Json;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

abstract class MongoDbStatement<S extends DbStatement<S>>
extends DbStatementBase<S> {
    static final Document EMPTY = Document.parse((String)Json.createObjectBuilder().build().toString());
    protected static final String JSON_OPERATION = "operation";
    protected static final String JSON_COLLECTION = "collection";
    protected static final String JSON_QUERY = "query";
    protected static final String JSON_VALUE = "value";
    protected static final String JSON_PROJECTION = "projection";
    private final MongoDatabase db;

    MongoDbStatement(MongoDatabase db, DbExecuteContext context) {
        super(context);
        this.db = db;
    }

    MongoDatabase db() {
        return this.db;
    }

    String prepareStatement(DbClientServiceContext serviceContext) {
        String statement = serviceContext.statement();
        DbStatementParameters stmtParams = serviceContext.statementParameters();
        if (stmtParams instanceof DbIndexedStatementParameters) {
            DbIndexedStatementParameters indexed = (DbIndexedStatementParameters)stmtParams;
            List params = indexed.parameters();
            return StatementParsers.indexedParser(statement, params).convert();
        }
        if (stmtParams instanceof DbNamedStatementParameters) {
            DbNamedStatementParameters named = (DbNamedStatementParameters)stmtParams;
            Map params = named.parameters();
            return StatementParsers.namedParser(statement, params).convert();
        }
        return statement;
    }

    static class MongoStatement {
        private final String preparedStmt;
        private final MongoOperation operation;
        private final String collection;
        private final Document query;
        private final Document value;
        private final Document projection;

        private static Document readStmt(String preparedStmt) {
            return Document.parse((String)preparedStmt);
        }

        MongoStatement(DbStatementType stmtType, String preparedStmt) {
            MongoOperation operation;
            Document jsonStmt;
            block16: {
                block15: {
                    this.preparedStmt = preparedStmt;
                    jsonStmt = MongoStatement.readStmt(preparedStmt);
                    if (!jsonStmt.containsKey((Object)MongoDbStatement.JSON_OPERATION)) break block15;
                    operation = MongoOperation.operationByName(jsonStmt.getString((Object)MongoDbStatement.JSON_OPERATION));
                    switch (stmtType) {
                        case QUERY: 
                        case GET: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.QUERY);
                            break block16;
                        }
                        case INSERT: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.INSERT);
                            break block16;
                        }
                        case UPDATE: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.UPDATE);
                            break block16;
                        }
                        case DELETE: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.DELETE);
                            break block16;
                        }
                        case DML: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.INSERT, MongoOperation.UPDATE, MongoOperation.DELETE);
                            break block16;
                        }
                        case COMMAND: {
                            MongoStatement.validateOperation(stmtType, operation, MongoOperation.COMMAND);
                            break block16;
                        }
                        default: {
                            throw new IllegalStateException("Operation type is not defined in statement, and cannot be inferred from statement type: " + String.valueOf(stmtType));
                        }
                    }
                }
                operation = switch (stmtType) {
                    case DbStatementType.QUERY, DbStatementType.GET -> MongoOperation.QUERY;
                    case DbStatementType.INSERT -> MongoOperation.INSERT;
                    case DbStatementType.UPDATE -> MongoOperation.UPDATE;
                    case DbStatementType.DELETE -> MongoOperation.DELETE;
                    case DbStatementType.COMMAND -> MongoOperation.COMMAND;
                    default -> throw new IllegalStateException("Operation type is not defined in statement, and cannot be inferred from statement type: " + String.valueOf(stmtType));
                };
            }
            this.operation = operation;
            this.collection = jsonStmt.getString((Object)MongoDbStatement.JSON_COLLECTION);
            this.value = (Document)jsonStmt.get((Object)MongoDbStatement.JSON_VALUE, Document.class);
            this.query = (Document)jsonStmt.get((Object)MongoDbStatement.JSON_QUERY, Document.class);
            this.projection = (Document)jsonStmt.get((Object)MongoDbStatement.JSON_PROJECTION, Document.class);
        }

        private static void validateOperation(DbStatementType dbStatementType, MongoOperation actual, MongoOperation ... expected) {
            for (MongoOperation operation : expected) {
                if (actual != operation) continue;
                return;
            }
            throw new IllegalStateException("Statement type is " + String.valueOf(dbStatementType) + ", yet operation in statement is: " + String.valueOf((Object)actual));
        }

        MongoOperation getOperation() {
            return this.operation;
        }

        String getCollection() {
            return this.collection;
        }

        Document getQuery() {
            return this.query != null ? this.query : EMPTY;
        }

        Document getValue() {
            return this.value;
        }

        Document getProjection() {
            return this.projection;
        }

        public String toString() {
            return this.preparedStmt;
        }
    }

    static enum MongoOperation {
        QUERY("query", "find", "select"),
        INSERT("insert"),
        UPDATE("update"),
        DELETE("delete"),
        COMMAND("command");

        private static final Map<String, MongoOperation> NAME_TO_OPERATION;
        private final String[] names;

        static MongoOperation operationByName(String name) {
            if (name == null) {
                return null;
            }
            return NAME_TO_OPERATION.get(name.toLowerCase());
        }

        private MongoOperation(String ... names) {
            this.names = names;
        }

        static {
            NAME_TO_OPERATION = new HashMap<String, MongoOperation>();
            for (MongoOperation value : MongoOperation.values()) {
                for (String name : value.names) {
                    NAME_TO_OPERATION.put(name.toLowerCase(), value);
                }
            }
        }
    }
}

