/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.config.Config;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbMapper;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.mongodb.MongoDbClient;
import io.helidon.dbclient.mongodb.MongoDbClientConfig;
import io.helidon.dbclient.spi.DbClientProviderBuilder;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public final class MongoDbClientProviderBuilder
implements DbClientProviderBuilder<MongoDbClientProviderBuilder> {
    private final List<DbClientService> clientServices = new LinkedList<DbClientService>();
    private final DbMapperManager.Builder dbMapperBuilder = DbMapperManager.builder();
    private String url;
    private String username;
    private String password;
    private String credDb;
    private DbStatements statements;
    private MapperManager mapperManager;
    private DbMapperManager dbMapperManager;
    private MongoDbClientConfig dbConfig;

    MongoDbClientProviderBuilder() {
    }

    public DbClient build() {
        if (null == this.dbMapperManager) {
            this.dbMapperManager = this.dbMapperBuilder.build();
        }
        if (null == this.mapperManager) {
            this.mapperManager = MapperManager.create();
        }
        if (null == this.dbConfig) {
            this.dbConfig = new MongoDbClientConfig(this.url, this.username, this.password, this.credDb);
        }
        return new MongoDbClient(this);
    }

    public MongoDbClientProviderBuilder config(Config config) {
        config.get("connection").asNode().ifPresentOrElse(conn -> {
            conn.get("url").asString().ifPresent(this::url);
            conn.get("username").asString().ifPresent(this::username);
            conn.get("password").asString().ifPresent(this::password);
        }, () -> {
            throw new DbClientException(String.format("No database connection configuration (%s) was found", config.get("connection").key()));
        });
        config.get("credDb").asString().ifPresent(this::credDb);
        this.statements = DbStatements.create((Config)config.get("statements"));
        return this;
    }

    public MongoDbClientProviderBuilder url(String url) {
        this.url = url;
        return this;
    }

    public MongoDbClientProviderBuilder username(String username) {
        this.username = username;
        return this;
    }

    public MongoDbClientProviderBuilder password(String password) {
        this.password = password;
        return this;
    }

    public MongoDbClientProviderBuilder credDb(String db) {
        this.credDb = db;
        return this;
    }

    public MongoDbClientProviderBuilder statements(DbStatements statements) {
        this.statements = statements;
        return this;
    }

    public MongoDbClientProviderBuilder addService(DbClientService clientService) {
        this.clientServices.add(clientService);
        return this;
    }

    public <TYPE> MongoDbClientProviderBuilder addMapper(final DbMapper<TYPE> dbMapper, final Class<TYPE> mappedClass) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <T> Optional<DbMapper<T>> mapper(Class<T> type) {
                if (type.equals(mappedClass)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return this;
    }

    public <TYPE> MongoDbClientProviderBuilder addMapper(final DbMapper<TYPE> dbMapper, final GenericType<TYPE> mappedType) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <T> Optional<DbMapper<T>> mapper(Class<T> type) {
                return Optional.empty();
            }

            public <T> Optional<DbMapper<T>> mapper(GenericType<T> type) {
                if (type.equals((Object)mappedType)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return this;
    }

    public MongoDbClientProviderBuilder mapperManager(MapperManager manager) {
        this.mapperManager = manager;
        return this;
    }

    public MongoDbClientProviderBuilder addMapperProvider(DbMapperProvider provider) {
        this.dbMapperBuilder.addMapperProvider(provider);
        return this;
    }

    List<DbClientService> clientServices() {
        return List.copyOf(this.clientServices);
    }

    DbMapperManager.Builder dbMapperBuilder() {
        return this.dbMapperBuilder;
    }

    DbStatements statements() {
        return this.statements;
    }

    MapperManager mapperManager() {
        return this.mapperManager;
    }

    DbMapperManager dbMapperManager() {
        return this.dbMapperManager;
    }

    MongoDbClientConfig dbConfig() {
        return this.dbConfig;
    }
}

