/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.AbstractDbExecute;
import io.helidon.dbclient.common.DbClientContext;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.mongodb.MongoDbStatementDml;
import io.helidon.dbclient.mongodb.MongoDbStatementGet;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;

public class MongoDbExecute
extends AbstractDbExecute
implements DbExecute {
    private final MongoDatabase db;
    private final DbClientContext clientContext;

    MongoDbExecute(MongoDatabase db, DbClientContext clientContext) {
        super(clientContext.statements());
        this.db = db;
        this.clientContext = clientContext;
    }

    public DbStatementQuery createNamedQuery(String statementName, String statement) {
        return new MongoDbStatementQuery(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.QUERY, (String)statementName, (String)statement));
    }

    public DbStatementGet createNamedGet(String statementName, String statement) {
        return new MongoDbStatementGet(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.GET, (String)statementName, (String)statement));
    }

    public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
        return new MongoDbStatementDml(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.DML, (String)statementName, (String)statement));
    }

    public DbStatementDml createNamedInsert(String statementName, String statement) {
        return new MongoDbStatementDml(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.INSERT, (String)statementName, (String)statement));
    }

    public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return new MongoDbStatementDml(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.UPDATE, (String)statementName, (String)statement));
    }

    public DbStatementDml createNamedDelete(String statementName, String statement) {
        return new MongoDbStatementDml(this.db, DbStatementContext.create((DbClientContext)this.clientContext, (DbStatementType)DbStatementType.DELETE, (String)statementName, (String)statement));
    }
}

