/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource;

import io.helidon.common.config.Config;
import io.helidon.data.sql.datasource.DataSourceConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Service.Singleton
class DataSourceConfigFactory
implements Service.ServicesFactory<DataSourceConfig> {
    private static final String SQL_DATA_SOURCES_CONFIG_KEY = "data.sources.sql";
    private final Supplier<Config> config;

    @Service.Inject
    DataSourceConfigFactory(Supplier<Config> config) {
        Objects.requireNonNull(config, "config must not be null");
        this.config = config;
    }

    public List<Service.QualifiedInstance<DataSourceConfig>> services() {
        Config dataConfig = this.config.get().get(SQL_DATA_SOURCES_CONFIG_KEY);
        if (dataConfig.get("provider").exists()) {
            return List.of(this.mapSingleConfig(dataConfig));
        }
        return this.fromList(dataConfig);
    }

    private List<Service.QualifiedInstance<DataSourceConfig>> fromList(Config dataConfig) {
        return dataConfig.asNodeList().stream().flatMap(Collection::stream).map(this::mapSingleConfig).collect(Collectors.toUnmodifiableList());
    }

    private Service.QualifiedInstance<DataSourceConfig> mapSingleConfig(Config config) {
        DataSourceConfig dataConfig = DataSourceConfig.create(config);
        return Service.QualifiedInstance.create((Object)dataConfig, (Qualifier[])new Qualifier[]{Qualifier.createNamed((String)dataConfig.name())});
    }
}

